#version 150

in vec4 vertexColor;
in vec2 texCoord;
in vec2 lightmapCoord;
in vec3 normal;

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform vec4 ColorModulator;
uniform vec4 FogColor;
uniform float GameTime;

out vec4 fragColor;

vec3 grayscale(vec3 color) {
    float average = 0.2126 * color.r + 0.7152 * color.g + 0.0722 * color.b;
    return vec3(average);
}

void main() {
    vec4 color = texture(Sampler0, texCoord) * vertexColor * ColorModulator;

    if (color.a < 0.1) {
        discard;
    }
    
    vec3 grayColor = grayscale(color.rgb);
    
    vec4 lightMap = texture(Sampler2, lightmapCoord);
    grayColor = grayColor * lightMap.rgb;
    
    fragColor = vec4(grayColor, color.a);
}