/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.network.ClientboundContainingSoundsMessage;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ContainingLanternBlockEntity
extends LanternBlockEntity {
    public ContainingLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.CONTAINING_LANTERN_BLOCK_ENTITY.value(), pos, state);
    }

    @Override
    public void serverTick() {
        ServerConfig.LanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).containingLantern;
        if (++this.ticks <= config.delay) {
            return;
        }
        int horizontalRange = config.horizontalRange;
        int verticalRange = config.verticalRange;
        this.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB((double)this.getBlockPos().getX() + 0.5 - (double)horizontalRange, (double)this.getBlockPos().getY() + 0.5 - (double)verticalRange, (double)this.getBlockPos().getZ() + 0.5 - (double)horizontalRange, (double)this.getBlockPos().getX() + 0.5 + (double)horizontalRange, (double)this.getBlockPos().getY() + 0.5 + (double)verticalRange, (double)this.getBlockPos().getZ() + 0.5 + (double)horizontalRange), entity -> !(entity instanceof Player)).forEach(entity -> {
            if (!entity.blockPosition().closerThan((Vec3i)this.getBlockPos(), (double)(horizontalRange / 2 + 1))) {
                if (this.getLevel().getBlockState(this.getBlockPos().above()).isAir()) {
                    entity.teleportTo((double)this.getBlockPos().getX(), (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ());
                } else {
                    entity.teleportTo((double)this.getBlockPos().getX(), (double)(this.getBlockPos().getY() - 1), (double)this.getBlockPos().getZ());
                }
                ArcaneLanterns.NETWORK.sendToAllNear((Vec3i)this.getBlockPos(), (ServerLevel)this.getLevel(), (ClientboundMessage)new ClientboundContainingSoundsMessage(this.getBlockPos()));
            }
        });
        this.ticks = 0;
    }
}

