/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.datagen;

import com.mojang.datafixers.util.Function4;
import gisellevonbingen.mmp.common.MoreMekanismProcessing;
import gisellevonbingen.mmp.common.chemical.MMPChemicals;
import gisellevonbingen.mmp.common.crafting.BlastingTaggedOutputRecipe;
import gisellevonbingen.mmp.common.crafting.SmeltingTaggedOutputRecipe;
import gisellevonbingen.mmp.common.crafting.conditions.CookingDustIntoIngotCondition;
import gisellevonbingen.mmp.common.crafting.conditions.ProcessingLevelCondition;
import gisellevonbingen.mmp.common.datagen.recipe.builder.CrystallizerTaggedOutputRecipeBuilder;
import gisellevonbingen.mmp.common.datagen.recipe.builder.ItemStackChemicalToTaggedOutputRecipeBuilder;
import gisellevonbingen.mmp.common.datagen.recipe.builder.ItemStackToTaggedOutputRecipeBuilder;
import gisellevonbingen.mmp.common.material.MaterialResultShape;
import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datagen.recipe.builder.ChemicalDissolutionRecipeBuilder;
import mekanism.api.datagen.recipe.builder.FluidChemicalToChemicalRecipeBuilder;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.registration.impl.SlurryRegistryObject;
import mekanism.common.registries.MekanismChemicals;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class RecipesGenerator
extends RecipeProvider {
    public RecipesGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        for (MaterialType materialType : MaterialType.values()) {
            new OreRecipesGenerator(materialType, output).build();
        }
    }

    public ResourceLocation getRecipeName(String output, String name) {
        return MoreMekanismProcessing.rl((output + "/" + name).toLowerCase());
    }

    public static class OreRecipesGenerator {
        private MaterialType materialType;
        private RecipeOutput output;
        private List<ICondition> conditions;

        public OreRecipesGenerator(MaterialType materialType, RecipeOutput output) {
            this.materialType = materialType;
            this.output = output;
            this.conditions = new ArrayList<ICondition>();
        }

        public ICondition createConditionHasState(MaterialState state) {
            return new NotCondition((ICondition)new TagEmptyCondition(state.getStateTagName(this.materialType)));
        }

        public void applyProcssingLevelCondition(int processingLevel, Runnable runnable) {
            this.applyCondition(new ProcessingLevelCondition(this.materialType.getBaseName(), processingLevel), runnable);
        }

        public void applyCondition(ICondition condition, Runnable runnable) {
            try {
                this.conditions.add(condition);
                runnable.run();
            }
            finally {
                this.conditions.remove(condition);
            }
        }

        public ICondition[] collect(Consumer<Consumer<ICondition>> consumer) {
            ArrayList list = new ArrayList();
            consumer.accept(list::add);
            return (ICondition[])list.toArray(ICondition[]::new);
        }

        public void applyConditionWithState(Consumer<ICondition> consumer, MaterialState stateInput) {
            if (!stateInput.hasOwnItem()) {
                consumer.accept(this.createConditionHasState(stateInput));
            }
            this.applyCondition(consumer);
        }

        public void applyCondition(Consumer<ICondition> consumer) {
            for (ICondition condition : this.conditions) {
                consumer.accept(condition);
            }
        }

        public void build() {
            this.applyProcssingLevelCondition(5, this::buildProcessingLevel5);
            this.applyProcssingLevelCondition(4, this::buildProcessingLevel4);
            this.applyProcssingLevelCondition(3, this::buildProcessingLevel3);
            this.applyProcssingLevelCondition(2, this::buildProcessingLevel2);
            this.buildOthers();
        }

        public void buildProcessingLevel5() {
            if (this.canProcess(MaterialState.CRYSTAL)) {
                ChemicalStackIngredient sulfuricAcid1;
                SlurryRegistryObject<Chemical, Chemical> chemicalRegistry;
                SlurryRegistryObject<Chemical, Chemical> dirtySlurry = chemicalRegistry = MMPChemicals.getSlurryRegistry(this.materialType);
                DeferredHolder cleanSlurry = chemicalRegistry.getCleanSlurry();
                FluidStackIngredient water = IngredientCreatorAccess.fluid().from(new FluidStack((Fluid)Fluids.WATER, 5));
                if (this.canProcess(MaterialState.ORE)) {
                    sulfuricAcid1 = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.SULFURIC_ACID, 1);
                    this.buildChemicalDissolution(MaterialState.ORE, 1, (Holder<Chemical>)dirtySlurry, 1000, sulfuricAcid1);
                }
                if (this.canProcess(MaterialState.RAW_ITEM)) {
                    sulfuricAcid1 = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.SULFURIC_ACID, 1);
                    this.buildChemicalDissolution(MaterialState.RAW_ITEM, 3, (Holder<Chemical>)dirtySlurry, 2000, sulfuricAcid1);
                    ChemicalStackIngredient sulfuricAcid2 = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.SULFURIC_ACID, 2);
                    this.buildChemicalDissolution(MaterialState.RAW_STORAGE_BLOCKS, 1, (Holder<Chemical>)dirtySlurry, 6000, sulfuricAcid2);
                }
                this.buildChemicalWashing(water, (Holder<Chemical>)dirtySlurry, (Holder<Chemical>)cleanSlurry);
                this.buildChemicalCrystallizing(IngredientCreatorAccess.chemicalStack().fromHolder((Holder)cleanSlurry, 200), MaterialState.CRYSTAL, 1);
                if (this.canProcess(MaterialState.SHARD)) {
                    ChemicalStackIngredient hydrogenChloride = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.HYDROGEN_CHLORIDE, 1);
                    this.buildItemStackChemicalToItemStack(MaterialState.CRYSTAL, 1, MaterialState.SHARD, 1, hydrogenChloride, (Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder>)((Function4)ItemStackChemicalToTaggedOutputRecipeBuilder::injecting));
                }
            }
        }

        public void buildProcessingLevel4() {
            if (this.canProcess(MaterialState.SHARD)) {
                if (this.canProcess(MaterialState.ORE)) {
                    ChemicalStackIngredient hydrogenChloride = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.HYDROGEN_CHLORIDE, 1);
                    this.buildItemStackChemicalToItemStack(MaterialState.ORE, 1, MaterialState.SHARD, 4, hydrogenChloride, (Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder>)((Function4)ItemStackChemicalToTaggedOutputRecipeBuilder::injecting));
                }
                if (this.canProcess(MaterialState.RAW_ITEM)) {
                    ChemicalStackIngredient hydrogenChloride1 = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.HYDROGEN_CHLORIDE, 1);
                    this.buildItemStackChemicalToItemStack(MaterialState.RAW_ITEM, 3, MaterialState.SHARD, 8, hydrogenChloride1, (Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder>)((Function4)ItemStackChemicalToTaggedOutputRecipeBuilder::injecting));
                    ChemicalStackIngredient hydrogenChloride2 = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.HYDROGEN_CHLORIDE, 2);
                    this.buildItemStackChemicalToItemStack(MaterialState.RAW_STORAGE_BLOCKS, 1, MaterialState.SHARD, 24, hydrogenChloride2, (Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder>)((Function4)ItemStackChemicalToTaggedOutputRecipeBuilder::injecting));
                }
                if (this.canProcess(MaterialState.CLUMP)) {
                    ChemicalStackIngredient oxygen = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.OXYGEN, 1);
                    this.buildItemStackChemicalToItemStack(MaterialState.SHARD, 1, MaterialState.CLUMP, 1, oxygen, (Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder>)((Function4)ItemStackChemicalToTaggedOutputRecipeBuilder::purifying));
                }
            }
        }

        public void buildProcessingLevel3() {
            if (this.canProcess(MaterialState.CLUMP)) {
                if (this.canProcess(MaterialState.ORE)) {
                    ChemicalStackIngredient oxygen = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.OXYGEN, 1);
                    this.buildItemStackChemicalToItemStack(MaterialState.ORE, 1, MaterialState.CLUMP, 3, oxygen, (Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder>)((Function4)ItemStackChemicalToTaggedOutputRecipeBuilder::purifying));
                }
                if (this.canProcess(MaterialState.RAW_ITEM)) {
                    ChemicalStackIngredient oxygen1 = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.OXYGEN, 1);
                    this.buildItemStackChemicalToItemStack(MaterialState.RAW_ITEM, 1, MaterialState.CLUMP, 2, oxygen1, (Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder>)((Function4)ItemStackChemicalToTaggedOutputRecipeBuilder::purifying));
                    ChemicalStackIngredient oxygen2 = IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.OXYGEN, 2);
                    this.buildItemStackChemicalToItemStack(MaterialState.RAW_STORAGE_BLOCKS, 1, MaterialState.CLUMP, 18, oxygen2, (Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder>)((Function4)ItemStackChemicalToTaggedOutputRecipeBuilder::purifying));
                }
                if (this.canProcess(MaterialState.DIRTY_DUST)) {
                    this.buildItemToItemStack(MaterialState.CLUMP, 1, MaterialState.DIRTY_DUST, 1, ItemStackToTaggedOutputRecipeBuilder::crushing);
                    if (this.canProcess(MaterialState.DUST)) {
                        this.buildItemToItemStack(MaterialState.DIRTY_DUST, 1, MaterialState.DUST, 1, ItemStackToTaggedOutputRecipeBuilder::enriching);
                    }
                }
            }
        }

        public void buildProcessingLevel2() {
            if (this.materialType.isRespectMekanism()) {
                return;
            }
            if (this.canProcess(MaterialState.ORE)) {
                if (this.materialType.getResultShape() == MaterialResultShape.GEM) {
                    if (this.canProcess(MaterialState.GEM)) {
                        this.buildItemToItemStack(MaterialState.ORE, 1, MaterialState.GEM, 2, ItemStackToTaggedOutputRecipeBuilder::enriching);
                    }
                } else if (this.canProcess(MaterialState.DUST)) {
                    this.buildItemToItemStack(MaterialState.ORE, 1, MaterialState.DUST, 2, ItemStackToTaggedOutputRecipeBuilder::enriching);
                }
            }
            if (this.canProcess(MaterialState.RAW_ITEM)) {
                this.buildItemToItemStack(MaterialState.RAW_ITEM, 3, MaterialState.DUST, 4, ItemStackToTaggedOutputRecipeBuilder::enriching);
            }
            if (this.canProcess(MaterialState.RAW_STORAGE_BLOCKS)) {
                this.buildItemToItemStack(MaterialState.RAW_STORAGE_BLOCKS, 1, MaterialState.DUST, 12, ItemStackToTaggedOutputRecipeBuilder::enriching);
            }
            if (this.canProcess(MaterialState.DUST)) {
                if (this.canProcess(MaterialState.INGOT)) {
                    this.buildCook(MaterialState.DUST, MaterialState.INGOT);
                    this.buildItemToItemStack(MaterialState.INGOT, 1, MaterialState.DUST, 1, ItemStackToTaggedOutputRecipeBuilder::crushing);
                }
                if (this.canProcess(MaterialState.GEM)) {
                    this.buildItemToItemStack(MaterialState.DUST, 1, MaterialState.GEM, 1, ItemStackToTaggedOutputRecipeBuilder::enriching);
                    this.buildItemToItemStack(MaterialState.GEM, 1, MaterialState.DUST, 1, ItemStackToTaggedOutputRecipeBuilder::crushing);
                }
            }
        }

        public void buildOthers() {
            if (this.materialType.isRespectMekanism()) {
                return;
            }
            if (this.canProcess(MaterialState.INGOT, MaterialState.NUGGET)) {
                this.buildNuggetFromIngot();
                this.buildIngotFromNugget();
            }
        }

        public boolean canProcess(MaterialState ... states) {
            return this.materialType.getResultShape().canProcess(Arrays.asList(states));
        }

        public String from(String name) {
            return "from_" + name;
        }

        public String from(String name, String method) {
            return this.from(name) + "_" + method;
        }

        public String from(MaterialState materialState) {
            return this.from(materialState.getBaseName());
        }

        public String from(MaterialState materialState, String method) {
            return this.from(materialState.getBaseName(), method);
        }

        public void buildChemicalCrystallizing(ChemicalStackIngredient chemicalInput, MaterialState stateOutput, int outputCount) {
            ItemStackIngredient output = this.getTaggedItemStackIngredient(stateOutput);
            CrystallizerTaggedOutputRecipeBuilder builder = CrystallizerTaggedOutputRecipeBuilder.crystallizing(chemicalInput, output);
            this.applyCondition(arg_0 -> ((CrystallizerTaggedOutputRecipeBuilder)builder).addCondition(arg_0));
            builder.build(this.output, this.getRecipeName(stateOutput, this.from("slurry")));
        }

        public void buildChemicalWashing(FluidStackIngredient fluidInput, Holder<Chemical> chemicalInput, Holder<Chemical> chemicalOutput) {
            ChemicalStackIngredient chemicalStackInput = IngredientCreatorAccess.chemicalStack().fromHolder(chemicalInput, 1);
            ChemicalStack chemicalStackOutput = new ChemicalStack(chemicalOutput, 1L);
            FluidChemicalToChemicalRecipeBuilder builder = FluidChemicalToChemicalRecipeBuilder.washing((FluidStackIngredient)fluidInput, (ChemicalStackIngredient)chemicalStackInput, (ChemicalStack)chemicalStackOutput);
            this.applyCondition(arg_0 -> ((FluidChemicalToChemicalRecipeBuilder)builder).addCondition(arg_0));
            builder.build(this.output, this.getRecipeName("slurry", "clean"));
        }

        public void buildChemicalDissolution(MaterialState stateInput, int inputCount, Holder<Chemical> chemicalOutput, int outputAmount, ChemicalStackIngredient chemicalInput) {
            ItemStackIngredient itemInput = this.getTaggedItemStackIngredient(stateInput, inputCount);
            ChemicalStack chemicalStackOutput = new ChemicalStack(chemicalOutput, (long)outputAmount);
            ChemicalDissolutionRecipeBuilder builder = ChemicalDissolutionRecipeBuilder.dissolution((ItemStackIngredient)itemInput, (ChemicalStackIngredient)chemicalInput, (ChemicalStack)chemicalStackOutput, (boolean)true);
            this.applyConditionWithState(arg_0 -> ((ChemicalDissolutionRecipeBuilder)builder).addCondition(arg_0), stateInput);
            builder.build(this.output, this.getRecipeName("slurry", "dirty/" + stateInput.getBaseName()));
        }

        public void buildItemStackChemicalToItemStack(MaterialState stateInput, int inputCount, MaterialState stateOutput, int outputCount, ChemicalStackIngredient chemicalInput, Function4<ItemStackIngredient, ChemicalStackIngredient, ItemStackIngredient, Boolean, ItemStackChemicalToTaggedOutputRecipeBuilder> function) {
            ItemStackIngredient itemInput = this.getTaggedItemStackIngredient(stateInput, inputCount);
            ItemStackIngredient output = this.getTaggedItemStackIngredient(stateOutput, outputCount);
            ItemStackChemicalToTaggedOutputRecipeBuilder builder = (ItemStackChemicalToTaggedOutputRecipeBuilder)((Object)function.apply((Object)itemInput, (Object)chemicalInput, (Object)output, (Object)true));
            this.applyConditionWithState(arg_0 -> ((ItemStackChemicalToTaggedOutputRecipeBuilder)builder).addCondition(arg_0), stateInput);
            builder.build(this.output, this.getRecipeName(stateOutput, this.from(stateInput)));
        }

        public void buildItemToItemStack(MaterialState stateInput, int inputCount, MaterialState stateOutput, int outputCount, BiFunction<ItemStackIngredient, ItemStackIngredient, ItemStackToTaggedOutputRecipeBuilder> function) {
            ItemStackIngredient input = this.getTaggedItemStackIngredient(stateInput, inputCount);
            ItemStackIngredient output = this.getTaggedItemStackIngredient(stateOutput, outputCount);
            ItemStackToTaggedOutputRecipeBuilder builder = function.apply(input, output);
            this.applyConditionWithState(arg_0 -> ((ItemStackToTaggedOutputRecipeBuilder)builder).addCondition(arg_0), stateInput);
            builder.build(this.output, this.getRecipeName(stateOutput, this.from(stateInput)));
        }

        public void buildCook(MaterialState stateInput, MaterialState stateOutput) {
            Ingredient itemInput = this.getTaggedIngredient(stateInput);
            String group = this.getGroup(stateOutput);
            ItemStackIngredient output = this.getTaggedItemStackIngredient(stateOutput);
            float experience = 0.35f;
            ArrayList<Tuple> list = new ArrayList<Tuple>();
            list.add(new Tuple((Object)"smelting", (Object)new SmeltingTaggedOutputRecipe(group, CookingBookCategory.MISC, itemInput, output, experience, 200)));
            list.add(new Tuple((Object)"blasting", (Object)new BlastingTaggedOutputRecipe(group, CookingBookCategory.MISC, itemInput, output, experience, 100)));
            for (Tuple tuple : list) {
                ResourceLocation recipeName = this.getRecipeName(stateOutput, this.from(stateInput, (String)tuple.getA()));
                this.output.accept(recipeName, (Recipe)tuple.getB(), null, this.collect(t -> {
                    this.applyConditionWithState((Consumer<ICondition>)t, stateInput);
                    if (stateInput == MaterialState.DUST && stateOutput == MaterialState.INGOT) {
                        t.accept(new CookingDustIntoIngotCondition(this.materialType.getBaseName()));
                    }
                }));
            }
        }

        public void buildIngotFromNugget() {
            MaterialState stateInput = MaterialState.NUGGET;
            MaterialState stateOutput = MaterialState.INGOT;
            ItemStack output = new ItemStack((ItemLike)stateOutput.getItem(this.materialType));
            ShapedRecipePattern pattern = ShapedRecipePattern.of(Map.of(Character.valueOf('#'), this.getTaggedIngredient(stateInput), Character.valueOf('*'), this.getExcatIngredient(stateInput)), (String[])new String[]{"###", "#*#", "###"});
            this.output.accept(this.getRecipeName(stateOutput, this.from(stateInput)), (Recipe)new ShapedRecipe(this.getGroup(stateOutput), CraftingBookCategory.MISC, pattern, output), null, this.collect(t -> this.applyConditionWithState((Consumer<ICondition>)t, stateInput)));
        }

        public void buildNuggetFromIngot() {
            MaterialState stateInput = MaterialState.INGOT;
            MaterialState stateOutput = MaterialState.NUGGET;
            ItemStack output = new ItemStack((ItemLike)stateOutput.getItem(this.materialType), 9);
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.add(this.getExcatIngredient(stateInput));
            this.output.accept(this.getRecipeName(stateOutput, this.from(stateInput)), (Recipe)new ShapelessRecipe(this.getGroup(stateOutput), CraftingBookCategory.MISC, output, NonNullList.copyOf(ingredients)), null, this.collect(t -> this.applyConditionWithState((Consumer<ICondition>)t, stateInput)));
        }

        public ResourceLocation getRecipeName(MaterialState stateOutput, String name) {
            return this.getRecipeName(stateOutput.getBaseName(), name);
        }

        public ResourceLocation getRecipeName(String stateOutput, String name) {
            return MoreMekanismProcessing.rl(("processing/" + this.materialType.getBaseName() + "/" + stateOutput + "/" + name).toLowerCase());
        }

        public Ingredient getExcatIngredient(MaterialState materialState) {
            return Ingredient.of((ItemLike[])new ItemLike[]{materialState.getItem(this.materialType)});
        }

        public Ingredient getTaggedIngredient(MaterialState materialState) {
            return Ingredient.of(this.getTag(materialState));
        }

        public ItemStackIngredient getTaggedItemStackIngredient(MaterialState materialState) {
            TagKey<Item> tag = this.getTag(materialState);
            return this.getTaggedItemStackIngredient(tag);
        }

        public ItemStackIngredient getTaggedItemStackIngredient(MaterialState materialState, int amount) {
            TagKey<Item> tag = this.getTag(materialState);
            return this.getTaggedItemStackIngredient(tag, amount);
        }

        public ItemStackIngredient getTaggedItemStackIngredient(TagKey<Item> tag) {
            return this.getTaggedItemStackIngredient(tag, 1);
        }

        public ItemStackIngredient getTaggedItemStackIngredient(TagKey<Item> tag, int amount) {
            return IngredientCreatorAccess.item().from(tag, amount);
        }

        public TagKey<Item> getTag(MaterialState materialState) {
            return ItemTags.create((ResourceLocation)materialState.getStateTagName(this.materialType));
        }

        public String getGroup(MaterialState stateOutput) {
            return BuiltInRegistries.ITEM.getKey((Object)stateOutput.getItem(this.materialType)).toString();
        }

        public MaterialType getMaterialType() {
            return this.materialType;
        }

        public RecipeOutput getConsumer() {
            return this.output;
        }
    }
}

