/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gisellevonbingen.mmp.common.crafting.ISingleIngredientRecipe;
import gisellevonbingen.mmp.common.crafting.ITaggedOutputRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CookingTaggedOutputSerializer<T extends AbstractCookingRecipe & ISingleIngredientRecipe>
implements RecipeSerializer<T> {
    private final Factory<T> factory;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public CookingTaggedOutputSerializer(Factory<T> pFactory, int pCookingTime) {
        this.factory = pFactory;
        this.codec = RecordCodecBuilder.mapCodec(p_300831_ -> p_300831_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(rec$ -> ((AbstractCookingRecipe)rec$).getGroup()), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(rec$ -> ((AbstractCookingRecipe)rec$).category()), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(rec$ -> ((ISingleIngredientRecipe)rec$).getIngredient()), (App)ItemStackIngredient.CODEC.fieldOf("result").forGetter(rec$ -> ((ITaggedOutputRecipe)rec$).getTaggedResult()), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(rec$ -> Float.valueOf(((AbstractCookingRecipe)rec$).getExperience())), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)pCookingTime).forGetter(rec$ -> ((AbstractCookingRecipe)rec$).getCookingTime())).apply((Applicative)p_300831_, pFactory::create));
        this.streamCodec = StreamCodec.of((x$0, x$1) -> this.toNetwork((RegistryFriendlyByteBuf)x$0, (Object)((AbstractCookingRecipe)x$1)), this::fromNetwork);
    }

    public MapCodec<T> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    private T fromNetwork(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        CookingBookCategory category = (CookingBookCategory)buffer.readEnum(CookingBookCategory.class);
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStackIngredient result = (ItemStackIngredient)ItemStackIngredient.STREAM_CODEC.decode((Object)buffer);
        float experience = buffer.readFloat();
        int cookingTime = buffer.readVarInt();
        return (T)((AbstractCookingRecipe)this.factory.create(group, category, ingredient, result, experience, cookingTime));
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        buffer.writeUtf(recipe.getGroup());
        buffer.writeEnum((Enum)recipe.category());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((ISingleIngredientRecipe)recipe).getIngredient());
        ItemStackIngredient.STREAM_CODEC.encode((Object)buffer, (Object)((ITaggedOutputRecipe)recipe).getTaggedResult());
        buffer.writeFloat(recipe.getExperience());
        buffer.writeVarInt(recipe.getCookingTime());
    }

    public AbstractCookingRecipe create(String group, CookingBookCategory category, Ingredient ingredient, ItemStackIngredient result, float experience, int cookingTime) {
        return (AbstractCookingRecipe)this.factory.create(group, category, ingredient, result, experience, cookingTime);
    }

    public static interface Factory<T> {
        public T create(String var1, CookingBookCategory var2, Ingredient var3, ItemStackIngredient var4, float var5, int var6);
    }
}

