/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.config;

import gisellevonbingen.mmp.common.config.ClientConfig;
import gisellevonbingen.mmp.common.config.CommonConfig;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MMPConfigs {
    public static final Map<ModConfig.Type, ModConfigSpec> SPECS = new HashMap<ModConfig.Type, ModConfigSpec>();
    public static final CommonConfig COMMON;
    public static final ModConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;

    public static void register(ModLoadingContext modLoadingContext) {
        MMPConfigs.register(modLoadingContext, ModConfig.Type.COMMON);
        Dist dist = FMLEnvironment.dist;
        if (dist.isClient()) {
            MMPConfigs.register(modLoadingContext, ModConfig.Type.CLIENT);
        }
        if (dist.isDedicatedServer()) {
            MMPConfigs.register(modLoadingContext, ModConfig.Type.SERVER);
        }
    }

    public static void register(ModLoadingContext modLoadingContext, ModConfig.Type type) {
        ModConfigSpec spec = SPECS.get(type);
        if (spec != null) {
            modLoadingContext.getActiveContainer().registerConfig(type, (IConfigSpec)spec);
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        MMPConfigs.parseConfig((ModConfigEvent)event);
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        MMPConfigs.parseConfig((ModConfigEvent)event);
    }

    public static void parseConfig(ModConfigEvent event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            CLIENT.parseConfig();
        }
    }

    static {
        Pair common = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)common.getLeft();
        COMMON_SPEC = (ModConfigSpec)common.getRight();
        SPECS.put(ModConfig.Type.COMMON, COMMON_SPEC);
        Pair client = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)client.getLeft();
        CLIENT_SPEC = (ModConfigSpec)client.getRight();
        SPECS.put(ModConfig.Type.CLIENT, CLIENT_SPEC);
    }
}

