/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.chemical;

import gisellevonbingen.mmp.common.chemical.ChemicalDeferredRegister2;
import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.common.registration.impl.SlurryRegistryObject;

public class MMPChemicals {
    public static final ChemicalDeferredRegister2 CHEMICALS = new ChemicalDeferredRegister2("moremekanismprocessing");
    public static final Map<MaterialType, SlurryRegistryObject<Chemical, Chemical>> MAP = new HashMap<MaterialType, SlurryRegistryObject<Chemical, Chemical>>();

    public static SlurryRegistryObject<Chemical, Chemical> getSlurryRegistry(MaterialType materialType) {
        return MAP.get((Object)materialType);
    }

    static {
        for (MaterialType materialType : MaterialType.values()) {
            MaterialState crystal = MaterialState.CRYSTAL;
            if (!materialType.getResultShape().canProcess(crystal)) continue;
            SlurryRegistryObject<Chemical, Chemical> registryObject = CHEMICALS.registerSlurries(materialType, new ChemicalBuildOperator(materialType));
            MAP.put(materialType, registryObject);
        }
    }

    public static final class ChemicalBuildOperator
    implements UnaryOperator<ChemicalBuilder> {
        private final MaterialType materialType;

        private ChemicalBuildOperator(MaterialType materialType) {
            this.materialType = materialType;
        }

        @Override
        public ChemicalBuilder apply(ChemicalBuilder builder) {
            return builder;
        }

        public MaterialType getOreType() {
            return this.materialType;
        }
    }
}

