/*
 * Decompiled with CFR 0.152.
 */
package tfar.functionalarmortrim.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.functionalarmortrim.FunctionalArmorTrim;
import tfar.functionalarmortrim.init.ModAttributes;
import tfar.functionalarmortrim.network.client.S2CConfigPacket;
import tfar.functionalarmortrim.platform.Services;

public class ConfigHandler {
    static final File file = new File("config/functionalarmortrim.json");
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<Item, Map<Holder<Attribute>, Map<EquipmentSlot, AttributeModifier>>> MAP = new HashMap<Item, Map<Holder<Attribute>, Map<EquipmentSlot, AttributeModifier>>>();

    static JsonObject createDefault() {
        JsonObject root = new JsonObject();
        JsonArray ironModifiers = new JsonArray();
        ConfigHandler.addMod(ironModifiers, (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, 2.0);
        ConfigHandler.addTrim(root, Items.IRON_INGOT, ironModifiers);
        JsonArray diamondModifiers = new JsonArray();
        ConfigHandler.addMod(diamondModifiers, (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, 2.0);
        ConfigHandler.addMod(diamondModifiers, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, 2.0);
        ConfigHandler.addTrim(root, Items.DIAMOND, diamondModifiers);
        JsonArray netheriteModifiers = new JsonArray();
        ConfigHandler.addMod(netheriteModifiers, (Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, 2.0);
        ConfigHandler.addMod(netheriteModifiers, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, 2.0);
        ConfigHandler.addMod(netheriteModifiers, ModAttributes.FIRE_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, 0.25);
        ConfigHandler.addTrim(root, Items.NETHERITE_INGOT, netheriteModifiers);
        JsonArray redstoneModifiers = new JsonArray();
        ConfigHandler.addMod(redstoneModifiers, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.1);
        ConfigHandler.addMod(redstoneModifiers, (Holder<Attribute>)Attributes.STEP_HEIGHT, AttributeModifier.Operation.ADD_VALUE, 1.0);
        ConfigHandler.addTrim(root, Items.REDSTONE, redstoneModifiers);
        JsonArray copperModifiers = new JsonArray();
        ConfigHandler.addMod(copperModifiers, Services.PLATFORM.getSwimSpeed(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.1);
        ConfigHandler.addTrim(root, Items.COPPER_INGOT, copperModifiers);
        JsonArray amethystModifiers = new JsonArray();
        ConfigHandler.addMod(amethystModifiers, ModAttributes.NIGHT_VISION, AttributeModifier.Operation.ADD_VALUE, 0.25);
        ConfigHandler.addTrim(root, Items.AMETHYST_SHARD, amethystModifiers);
        JsonArray lapisModifiers = new JsonArray();
        ConfigHandler.addMod(lapisModifiers, ModAttributes.EXPERIENCE_BOOST, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.1);
        ConfigHandler.addTrim(root, Items.LAPIS_LAZULI, lapisModifiers);
        JsonArray quartzModifiers = new JsonArray();
        ConfigHandler.addMod(quartzModifiers, ModAttributes.THORNS, AttributeModifier.Operation.ADD_VALUE, 1.0);
        ConfigHandler.addTrim(root, Items.QUARTZ, quartzModifiers);
        JsonArray emeraldModifiers = new JsonArray();
        ConfigHandler.addMod(emeraldModifiers, ModAttributes.GOSSIP_BOOST, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.1);
        ConfigHandler.addTrim(root, Items.EMERALD, emeraldModifiers);
        return root;
    }

    static void addTrim(JsonObject root, Item item, JsonArray mods) {
        root.add(ConfigHandler.getName(item), (JsonElement)mods);
    }

    static void addMod(JsonArray array, Holder<Attribute> attribute, AttributeModifier.Operation operation, double amount) {
        JsonObject object = new JsonObject();
        object.addProperty("attribute", ConfigHandler.getName(attribute));
        object.addProperty("operation", operation.name().toLowerCase(Locale.ROOT));
        object.addProperty("amount", (Number)amount);
        array.add((JsonElement)object);
    }

    public static JsonObject read(Gson gson) {
        JsonObject jsonObject;
        ConfigHandler.writeIfEmpty();
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            JsonReader jsonReader = new JsonReader((Reader)reader);
            LOGGER.info("Loading existing config");
            jsonObject = (JsonObject)gson.fromJson(jsonReader, JsonObject.class);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return jsonObject;
    }

    public static void load(JsonObject jsonObject) {
        MAP.clear();
        for (Map.Entry entry : jsonObject.asMap().entrySet()) {
            String key = (String)entry.getKey();
            ResourceLocation location = ResourceLocation.parse((String)key);
            if (!BuiltInRegistries.ITEM.containsKey(location)) {
                LOGGER.info("Skipping unregistered item {}", (Object)key);
                continue;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(location);
            JsonArray mods = ((JsonElement)entry.getValue()).getAsJsonArray();
            HashMap attributeMapMap = new HashMap();
            for (JsonElement element : mods) {
                JsonObject obj = element.getAsJsonObject();
                ResourceLocation attrLocation = ResourceLocation.parse((String)obj.get("attribute").getAsString());
                Optional attribute = BuiltInRegistries.ATTRIBUTE.getHolder(attrLocation);
                if (attribute.isEmpty()) {
                    LOGGER.info("Skipping unregistered attribute {}", (Object)attrLocation);
                    continue;
                }
                AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)obj.get("operation").getAsString().toUpperCase(Locale.ROOT));
                double amount = obj.get("amount").getAsDouble();
                HashMap<EquipmentSlot, AttributeModifier> attributeModifierMap = new HashMap<EquipmentSlot, AttributeModifier>();
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (!slot.isArmor()) continue;
                    ResourceLocation id = FunctionalArmorTrim.trim_modifiers[slot.getIndex()];
                    AttributeModifier modifier = new AttributeModifier(id, amount, operation);
                    attributeModifierMap.put(slot, modifier);
                }
                attributeMapMap.put((Holder)attribute.get(), attributeModifierMap);
            }
            MAP.put(item, attributeMapMap);
        }
        MinecraftServer server = Services.PLATFORM.getStaticServer();
        if (server != null) {
            server.getPlayerList().getPlayers().forEach(player -> Services.PLATFORM.sendToClient(S2CConfigPacket.create(MAP), (ServerPlayer)player));
        }
    }

    public static void writeIfEmpty() {
        if (!file.exists()) {
            ConfigHandler.write(file);
        }
    }

    public static void write(File file) {
        Gson gson = new Gson();
        JsonWriter writer = null;
        try {
            writer = gson.newJsonWriter((Writer)new FileWriter(file));
            writer.setIndent("    ");
            gson.toJson((JsonElement)ConfigHandler.createDefault(), writer);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Couldn't save config");
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static String getName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }

    public static Item getItem(String s) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)s));
    }

    public static String getName(Holder<Attribute> attribute) {
        return attribute.getRegisteredName();
    }

    public static Holder<Attribute> getAttribute(String s) {
        return (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)s)).orElseThrow();
    }
}

