/*
 * Decompiled with CFR 0.152.
 */
package tfar.functionalarmortrim;

import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import tfar.functionalarmortrim.init.ModAttributes;

public class FunctionalArmorTrim {
    public static final String MOD_ID = "functionalarmortrim";
    public static final UUID[] trim_slot_uuids = new UUID[]{UUID.fromString("81a9ed67-25f2-40f5-9a14-5607bd76b506"), UUID.fromString("71dcc566-b25a-4f1a-b564-c9a8aa9e784f"), UUID.fromString("0a2787e9-a297-4ac9-9935-bed6f145e00c"), UUID.fromString("eb4dbe61-f520-44fe-81ee-7754188eb320")};
    public static final ResourceLocation[] trim_modifiers = new ResourceLocation[]{FunctionalArmorTrim.id(EquipmentSlot.HEAD.getName()), FunctionalArmorTrim.id(EquipmentSlot.CHEST.getName()), FunctionalArmorTrim.id(EquipmentSlot.LEGS.getName()), FunctionalArmorTrim.id(EquipmentSlot.FEET.getName())};

    public static void init() {
    }

    public static double blockDrops(Entity breaker) {
        double d;
        if (breaker instanceof Player) {
            Player player = (Player)breaker;
            d = player.getAttributeValue(ModAttributes.EXPERIENCE_BOOST);
        } else {
            d = 1.0;
        }
        return d;
    }

    public static double livingExperienceDrops(Player player) {
        return player != null ? player.getAttributeValue(ModAttributes.EXPERIENCE_BOOST) : 1.0;
    }

    public static void livingDamagePost(LivingEntity target, DamageSource source) {
        double quartz;
        Entity attacker = source.getDirectEntity();
        if (attacker instanceof LivingEntity && (quartz = target.getAttributeValue(ModAttributes.THORNS)) > 0.0) {
            attacker.hurt(target.damageSources().thorns((Entity)target), (float)quartz);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean entityInvulnerabilityCheck(Entity target, DamageSource source) {
        if (!(target instanceof LivingEntity)) return false;
        LivingEntity livingTarget = (LivingEntity)target;
        if (!source.is(DamageTypeTags.IS_FIRE)) return false;
        if (!(livingTarget.getAttributeValue(ModAttributes.FIRE_RESISTANCE) >= 1.0)) return false;
        return true;
    }

    public static double livingIncomingDamageEvent(LivingEntity target, DamageSource source) {
        return 1.0 - (source.is(DamageTypeTags.IS_FIRE) ? target.getAttributeValue(ModAttributes.FIRE_RESISTANCE) : 0.0);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static ArmorTrim getTrim(ItemStack stack) {
        return (ArmorTrim)stack.get(DataComponents.TRIM);
    }

    public static TrimMaterial getTrimMaterial(ItemStack stack) {
        ArmorTrim armorTrim = FunctionalArmorTrim.getTrim(stack);
        return armorTrim == null ? null : (TrimMaterial)armorTrim.material().value();
    }

    public static Item getTrimItem(ItemStack stack) {
        TrimMaterial trimMaterial = FunctionalArmorTrim.getTrimMaterial(stack);
        return trimMaterial == null ? null : (Item)trimMaterial.ingredient().value();
    }
}

