/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.gametest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedcrafting.core.part.PartTypeInterfaceCraftingBase;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integratedcrafting.part.aspect.CraftingAspects;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

public class GameTestHelpersIntegratedCrafting {
    public static INetworkPositions<PartTypeInterfaceCrafting.State> createBasicNetwork(GameTestHelper helper, BlockPos pos) {
        return GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, pos, false);
    }

    public static <T extends PartTypeInterfaceCraftingBase.State<?, ?>> INetworkPositions<T> createBasicNetwork(GameTestHelper helper, BlockPos pos, boolean attuned) {
        return GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, pos, attuned, Blocks.CRAFTING_TABLE);
    }

    public static INetworkPositions<PartTypeInterfaceCrafting.State> createBasicNetwork(GameTestHelper helper, BlockPos pos, Block ... crafters) {
        return GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, pos, false, crafters);
    }

    public static <T extends PartTypeInterfaceCraftingBase.State<?, ?>> INetworkPositions<T> createBasicNetwork(GameTestHelper helper, BlockPos pos, boolean attuned, Block ... crafters) {
        PartTypeInterfaceCraftingBase partInterface = attuned ? org.cyclops.integratedcrafting.part.PartTypes.INTERFACE_CRAFTING_ATTUNED : org.cyclops.integratedcrafting.part.PartTypes.INTERFACE_CRAFTING;
        helper.setBlock(pos, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(pos), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(pos), (Direction)Direction.NORTH, (IPartType)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER, (ItemStack)new ItemStack((ItemLike)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER.getItem()));
        helper.setBlock(pos.east(), Blocks.CHEST);
        BlockPos posi = pos;
        ArrayList interfaces = Lists.newArrayList();
        ArrayList interfaceStates = Lists.newArrayList();
        ArrayList interfaceRecipeAdders = Lists.newArrayList();
        for (Block crafter : crafters) {
            if (!pos.equals((Object)posi)) {
                helper.setBlock(posi, (Block)RegistryEntries.BLOCK_CABLE.value());
            }
            helper.setBlock(posi.above(), (Block)RegistryEntries.BLOCK_CABLE.value());
            helper.setBlock(posi.above().west(), (Block)RegistryEntries.BLOCK_CABLE.value());
            PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.above().west()), (Direction)Direction.DOWN, (IPartType)partInterface, (ItemStack)new ItemStack((ItemLike)partInterface.getItem()));
            helper.setBlock(posi.west(), crafter);
            if (crafter == Blocks.FURNACE) {
                helper.setBlock(posi.west(), (BlockState)crafter.defaultBlockState().setValue((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.EAST));
                FurnaceBlockEntity furnace = (FurnaceBlockEntity)helper.getBlockEntity(posi.west());
                furnace.setItem(1, new ItemStack((ItemLike)Items.COAL, 64));
                helper.setBlock(posi.below(), (Block)RegistryEntries.BLOCK_CABLE.value());
                helper.setBlock(posi.below().west(), (Block)RegistryEntries.BLOCK_CABLE.value());
                PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.below().west()), (Direction)Direction.UP, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
                GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.below().west()), (Direction)Direction.UP), (IAspectWrite)TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
            }
            interfaces.add(PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.above().west()), (Direction)Direction.DOWN));
            PartTypeInterfaceCraftingBase.State partStateCraftingInterface = (PartTypeInterfaceCraftingBase.State)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.above().west()), (Direction)Direction.DOWN)).getState();
            interfaceStates.add(partStateCraftingInterface);
            interfaceRecipeAdders.add(pair -> {
                ItemStack variableRecipe = GameTestHelpersIntegratedCrafting.createVariableForRecipe((Level)helper.getLevel(), (RecipeType)pair.getMiddle(), (ResourceLocation)pair.getRight());
                if (partStateCraftingInterface instanceof PartTypeInterfaceCrafting.State) {
                    PartTypeInterfaceCrafting.State partStateCraftingInterfaceRegular = (PartTypeInterfaceCrafting.State)partStateCraftingInterface;
                    partStateCraftingInterfaceRegular.getInventoryVariables().setItem(((Integer)pair.getLeft()).intValue(), variableRecipe);
                }
            });
            posi = posi.south();
        }
        return new NetworkPositions(pos.east(), PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(pos), (Direction)Direction.NORTH), interfaces, interfaceStates, interfaceRecipeAdders);
    }

    public static ItemStack createVariableForRecipe(Level level, RecipeType<?> recipeType, ResourceLocation recipeName) {
        RecipeHolder recipeUnknown = null;
        try {
            recipeUnknown = (RecipeHolder)IModHelpers.get().getCraftingHelpers().getServerRecipe(recipeType, recipeName).orElseThrow(() -> new IllegalStateException("Recipe " + recipeName.toString() + " could not be found"));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        IdentityHashMap recipeIn = Maps.newIdentityHashMap();
        ArrayList alternatives = Lists.newArrayList();
        IdentityHashMap recipeOut = Maps.newIdentityHashMap();
        Object object = recipeUnknown.value();
        if (object instanceof CraftingRecipe) {
            CraftingRecipe recipeCrafting = (CraftingRecipe)object;
            if (recipeCrafting.canCraftInDimensions(2, 2)) {
                int i = 0;
                for (Ingredient ingredient : recipeCrafting.getIngredients()) {
                    if (ingredient.isEmpty()) {
                        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)5)})));
                    } else {
                        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ingredient.getItems()[0], (Object)5)})));
                    }
                    if (++i != 2) continue;
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)5)})));
                }
            } else {
                for (Ingredient ingredient : recipeCrafting.getIngredients()) {
                    if (ingredient.isEmpty()) {
                        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)5)})));
                        continue;
                    }
                    boolean wasTag = false;
                    for (Ingredient.Value value : ingredient.getValues()) {
                        if (!(value instanceof Ingredient.TagValue)) continue;
                        Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                        alternatives.add(new PrototypedIngredientAlternativesItemStackTag((List)Lists.newArrayList((Object[])new String[]{tagValue.tag().location().toString()}), Integer.valueOf(1), 1L));
                        wasTag = true;
                        break;
                    }
                    if (wasTag) continue;
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ingredient.getItems()[0], (Object)5)})));
                }
            }
            recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
            recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipeCrafting.getResultItem((HolderLookup.Provider)level.registryAccess())}));
        } else {
            object = recipeUnknown.value();
            if (object instanceof SmeltingRecipe) {
                SmeltingRecipe recipeSmelting = (SmeltingRecipe)object;
                for (Ingredient ingredient : recipeSmelting.getIngredients()) {
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ingredient.getItems()[0], (Object)5)})));
                }
                recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
                recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipeSmelting.getResultItem((HolderLookup.Provider)level.registryAccess())}));
            } else {
                object = recipeUnknown.value();
                if (object instanceof SmithingTransformRecipe) {
                    SmithingTransformRecipe recipeSmithing = (SmithingTransformRecipe)object;
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)recipeSmithing.template.getItems()[0], (Object)5)})));
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)recipeSmithing.base.getItems()[0], (Object)5)})));
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)recipeSmithing.addition.getItems()[0], (Object)5)})));
                    recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
                    recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipeSmithing.getResultItem((HolderLookup.Provider)level.registryAccess())}));
                } else {
                    object = recipeUnknown.value();
                    if (object instanceof StonecutterRecipe) {
                        StonecutterRecipe recipeStoneCutter = (StonecutterRecipe)object;
                        alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)((Ingredient)recipeStoneCutter.getIngredients().getFirst()).getItems()[0], (Object)5)})));
                        recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
                        recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipeStoneCutter.getResultItem((HolderLookup.Provider)level.registryAccess())}));
                    } else {
                        throw new IllegalStateException("Unknown recipe type " + String.valueOf(recipeType));
                    }
                }
            }
        }
        return GameTestHelpersIntegratedDynamics.createVariableForValue((Level)level, (IValueType)ValueTypes.OBJECT_RECIPE, (IValue)ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)recipeIn, (IMixedIngredients)new MixedIngredients((Map)recipeOut))));
    }

    public static void enableRecipeInWriter(GameTestHelper helper, PartPos writerPos, ItemStack itemStack) {
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)writerPos, CraftingAspects.Write.ITEMSTACK_CRAFT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)itemStack)));
    }

    public static <T extends IValueType<V>, V extends IValue> void setWriterAspectProperty(PartPos writerPos, IAspectWrite aspect, IAspectPropertyTypeInstance<T, V> type, V value) {
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)writerPos);
        IAspectProperties properties = aspect.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)writerPos), partStateHolder.getState());
        properties.setValue(type, value);
        partStateHolder.getState().setAspectProperties((IAspect)aspect, properties);
    }

    public static <T extends IValueType<V>, V extends IValue> void setCraftingInterfaceBlockingMode(PartPos writerPos, boolean blocking) {
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)writerPos);
        ((PartTypeInterfaceCrafting.State)partStateHolder.getState()).getCraftingJobHandler().setBlockingJobsMode(blocking);
    }

    public static <T extends IValueType<V>, V extends IValue> void setCraftingInterfaceUpdateInterval(PartPos writerPos, int updateInterval) {
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)writerPos);
        partStateHolder.getState().setUpdateInterval(updateInterval);
    }

    public static void chestContains(GameTestHelper helper, ChestBlockEntity chest, ItemStack itemStack) {
        boolean found = false;
        for (int i = 0; i < chest.getContainerSize(); ++i) {
            if (!ItemStack.matches((ItemStack)chest.getItem(i), (ItemStack)itemStack)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new GameTestAssertException("Could not find " + String.valueOf(itemStack) + " in chest");
        }
    }

    public static interface INetworkPositions<T extends PartTypeInterfaceCraftingBase.State<?, ?>> {
        public BlockPos chest();

        public PartPos writer();

        public List<PartPos> interfaces();

        public List<T> interfaceStates();

        public List<Consumer<Triple<Integer, RecipeType<?>, ResourceLocation>>> interfaceRecipeAdders();
    }

    public record NetworkPositions<T extends PartTypeInterfaceCraftingBase.State<?, ?>>(BlockPos chest, PartPos writer, List<PartPos> interfaces, List<T> interfaceStates, List<Consumer<Triple<Integer, RecipeType<?>, ResourceLocation>>> interfaceRecipeAdders) implements INetworkPositions<T>
    {
    }
}

