/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.event;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import cy.jdkdigital.utilitarian.module.SnadModule;
import cy.jdkdigital.utilitarian.module.TPSMeterModule;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import cy.jdkdigital.utilitarian.module.UtilityItemModule;
import cy.jdkdigital.utilitarian.network.SyncSoundMufflerData;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="utilitarian", bus=EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void registerBlockEntityCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)UtilityBlockModule.WELL_BEHAVED_DROPPER_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("utilitarian").versioned("1");
        registrar.playToClient(SyncSoundMufflerData.TYPE, SyncSoundMufflerData.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(SyncSoundMufflerData::clientHandle, SyncSoundMufflerData::serverHandle));
    }

    @SubscribeEvent
    public static void tabContents(BuildCreativeModeTabContentsEvent event) {
        if (((Boolean)Config.NO_SOLICITING_ENABLED.get()).booleanValue()) {
            if (event.getTabKey().equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
                event.accept((ItemLike)NoSolicitingModule.RESTRAINING_ORDER.get());
                event.accept((ItemLike)NoSolicitingModule.NO_SOLICITING_BANNER_ITEM.get());
                event.accept((ItemLike)NoSolicitingModule.NO_RAIDER_BLOCK_ITEM.get());
                event.accept((ItemLike)NoSolicitingModule.SOLICITING_CARPET_ITEM.get(DyeColor.WHITE).get());
                event.accept((ItemLike)NoSolicitingModule.TRAPPED_SOLICITING_CARPET_ITEM.get(DyeColor.WHITE).get());
                event.accept((ItemLike)UtilityBlockModule.FLUID_HOPPER_BLOCK.get());
                event.accept((ItemLike)UtilityBlockModule.ANGEL_BLOCK.get());
                event.accept((ItemLike)UtilityBlockModule.REDSTONE_CLOCK_BLOCK.get());
                event.accept((ItemLike)UtilityItemModule.TROWEL.get());
                event.accept((ItemLike)UtilityItemModule.TINY_COAL.get());
                event.accept((ItemLike)UtilityItemModule.TINY_CHARCOAL.get());
                event.accept((ItemLike)UtilityItemModule.UNNAME_TAG.get());
                event.accept((ItemLike)UtilityItemModule.SLIME_BUCKET.get());
            }
            if (event.getTabKey().equals(CreativeModeTabs.COLORED_BLOCKS)) {
                for (DyeColor color : DyeColor.values()) {
                    event.accept((ItemLike)NoSolicitingModule.SOLICITING_CARPET_ITEM.get(color).get());
                    event.accept((ItemLike)NoSolicitingModule.TRAPPED_SOLICITING_CARPET_ITEM.get(color).get());
                }
            }
        }
        if (event.getTabKey().equals(CreativeModeTabs.REDSTONE_BLOCKS)) {
            event.accept((ItemLike)TPSMeterModule.TPS_METER_ITEM.get());
            event.accept((ItemLike)UtilityBlockModule.REDSTONE_CLOCK_BLOCK.get());
            event.accept((ItemLike)UtilityBlockModule.LAPIS_LAMP.get());
            event.accept((ItemLike)UtilityBlockModule.INVERTED_LAPIS_LAMP.get());
            event.accept((ItemLike)UtilityBlockModule.INVERTED_REDSTONE_LAMP.get());
        }
        if (event.getTabKey().equals(CreativeModeTabs.FUNCTIONAL_BLOCKS)) {
            event.accept((ItemLike)UtilityBlockModule.ANGEL_BLOCK_ITEM.get());
            event.accept((ItemLike)UtilityBlockModule.SOUND_MUFFLER_ITEM.get());
            event.accept((ItemLike)TPSMeterModule.TPS_METER_ITEM.get());
            event.accept((ItemLike)SnadModule.SNAD_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.RED_SNAD_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.SOUL_SNAD_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.DRIT_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.GRRASS_BLOCK_ITEM.get());
            event.accept((ItemLike)SnadModule.CURSED_GRRASS_BLOCK_ITEM.get());
        }
    }
}

