/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.event;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.Utilitarian;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import cy.jdkdigital.utilitarian.module.SnadModule;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import cy.jdkdigital.utilitarian.module.UtilityItemModule;
import cy.jdkdigital.utilitarian.network.SyncSoundMufflerData;
import cy.jdkdigital.utilitarian.util.Helper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="utilitarian")
public class EventHandler {
    public static Set<String> CLIENT_MUFFLER_LIST = new HashSet<String>();

    @SubscribeEvent
    static void onTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().is(Items.WIND_CHARGE)) {
            event.getToolTip().add(Component.translatable((String)"utilitarian.wind_charge.tooltip").withStyle(ChatFormatting.AQUA));
        }
        if (event.getItemStack().is(UtilityBlockModule.SOUND_MUFFLER_ITEM)) {
            event.getToolTip().add(Component.translatable((String)"utilitarian.sound_muffler.tooltip", (Object[])new Object[]{Config.SOUND_MUFFLER_BLOCK_RANGE.get()}).withStyle(ChatFormatting.AQUA));
        }
    }

    @SubscribeEvent
    static void onEntitySpawn(EntityJoinLevelEvent event) {
        Level lightningBolt;
        Player player;
        WindCharge windCharge;
        Level executor;
        Entity entity;
        ServerLevel serverLevel;
        Level level;
        if (((Boolean)Config.NO_SOLICITING_ENABLED.get()).booleanValue() && !event.loadedFromDisk() && (level = event.getLevel()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof LivingEntity && (entity = (LivingEntity)level).getType().is(NoSolicitingModule.TRADER_BLACKLIST)) {
                executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                executor.tell((Runnable)new TickTask(0, () -> EventHandler.lambda$onEntitySpawn$0(serverLevel, event, (LivingEntity)entity)));
            }
        }
        if (((Boolean)Config.WIND_CHARGE_AIR_SUPPLY_ENABLED.get()).booleanValue() && !event.getLevel().isClientSide && (entity = event.getEntity()) instanceof WindCharge && (executor = (windCharge = (WindCharge)entity).getOwner()) instanceof Player && (player = (Player)executor).getAirSupply() < player.getMaxAirSupply()) {
            player.setAirSupply(Math.min(player.getMaxAirSupply(), player.getAirSupply() + (Integer)Config.WIND_CHARGE_AIR_AMOUNT.get()));
        }
        if (((Boolean)Config.CURSED_EARTH_ENABLED.get()).booleanValue() && (executor = event.getLevel()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)executor;
            executor = event.getEntity();
            if (executor instanceof LightningBolt) {
                lightningBolt = (LightningBolt)executor;
                Vec3 vec3 = lightningBolt.position();
                BlockPos hitPosition = BlockPos.containing((double)vec3.x, (double)(vec3.y - 1.0E-6), (double)vec3.z);
                BlockState hitState = serverLevel.getBlockState(hitPosition);
                if (hitState.is(Blocks.LIGHTNING_ROD)) {
                    hitState = serverLevel.getBlockState(hitPosition.below());
                }
                if (hitState.is(SnadModule.GRRASS_BLOCK)) {
                    BlockPos.betweenClosedStream((AABB)new AABB(hitPosition).inflate(2.0)).forEach(pos -> {
                        if (serverLevel.getBlockState(pos).is(SnadModule.GRRASS_BLOCK)) {
                            int weight = Math.max(0, 15 - (int)pos.distSqr((Vec3i)hitPosition));
                            if (serverLevel.getRandom().nextInt(15) < weight) {
                                serverLevel.setBlockAndUpdate(pos, ((Block)SnadModule.CURSED_GRRASS_BLOCK.get()).defaultBlockState());
                            }
                        }
                    });
                }
            }
        }
        if (!event.loadedFromDisk() && ((Boolean)Config.NO_RAIDER_ENABLED.get()).booleanValue() && (lightningBolt = event.getLevel()) instanceof ServerLevel) {
            List<BlockPos> nearbySoliciting;
            serverLevel = (ServerLevel)lightningBolt;
            if (event.getEntity().getType().is(NoSolicitingModule.RAIDER_BLACKLIST) && !(nearbySoliciting = Helper.locateNearbyNoRaider(serverLevel, event.getEntity().blockPosition())).isEmpty()) {
                Registry registry = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE);
                registry.getTag(NoSolicitingModule.RAIDER_OUTPOSTS).ifPresent(holders -> {
                    Pair pair = serverLevel.getChunkSource().getGenerator().findNearestMapStructure(serverLevel, (HolderSet)holders, event.getEntity().blockPosition(), 4, false);
                    if (pair != null) {
                        BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                        executor.tell((Runnable)new TickTask(0, () -> event.getEntity().discard()));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    static void onSoundAtPosition(PlayLevelSoundEvent.AtPosition event) {
        BlockPos position = new BlockPos((int)event.getPosition().x, (int)event.getPosition().y, (int)event.getPosition().z);
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            List<BlockPos> nearbySoundMufflers = Helper.locateNearbySoundMuffler(level2, position, UtilityBlockModule.SOUND_MUFFLER_POI_TAG);
            event.setCanceled(!nearbySoundMufflers.isEmpty());
        } else {
            ArrayList<String> list = new ArrayList<String>(CLIENT_MUFFLER_LIST);
            for (String s : list) {
                BlockPos mufflerPos = BlockPos.of((long)Long.parseLong(s));
                if (!event.getLevel().getBlockState(mufflerPos).is(UtilityBlockModule.SOUND_MUFFLER)) {
                    CLIENT_MUFFLER_LIST.remove(s);
                    continue;
                }
                if (!(mufflerPos.distToCenterSqr((double)position.getX(), (double)position.getY(), (double)position.getZ()) <= (double)((Integer)Config.SOUND_MUFFLER_BLOCK_RANGE.get()).intValue())) continue;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    static void onSoundAtEntity(PlayLevelSoundEvent.AtEntity event) {
        block3: {
            BlockPos position;
            block2: {
                position = event.getEntity().blockPosition();
                Level level = event.getLevel();
                if (!(level instanceof ServerLevel)) break block2;
                ServerLevel level2 = (ServerLevel)level;
                List<BlockPos> nearbySoundMuffler = Helper.locateNearbySoundMuffler(level2, position, UtilityBlockModule.SOUND_MUFFLER_POI_TAG);
                if (nearbySoundMuffler.isEmpty()) break block3;
                event.setCanceled(true);
                break block3;
            }
            ArrayList<String> list = new ArrayList<String>(CLIENT_MUFFLER_LIST);
            for (String s : list) {
                BlockPos mufflerPos = BlockPos.of((long)Long.parseLong(s));
                if (!event.getLevel().getBlockState(mufflerPos).is(UtilityBlockModule.SOUND_MUFFLER)) {
                    CLIENT_MUFFLER_LIST.remove(s);
                    continue;
                }
                if (!(mufflerPos.distToCenterSqr((double)position.getX(), (double)position.getY(), (double)position.getZ()) <= (double)((Integer)Config.SOUND_MUFFLER_BLOCK_RANGE.get()).intValue())) continue;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void canSleep(CanPlayerSleepEvent canPlayerSleepEvent) {
        if (((Boolean)Config.BETTER_SLEEP_ENABLED.get()).booleanValue() && canPlayerSleepEvent.getVanillaProblem() != null) {
            if (canPlayerSleepEvent.getVanillaProblem().equals((Object)Player.BedSleepingProblem.TOO_FAR_AWAY)) {
                canPlayerSleepEvent.setProblem(null);
            } else if (canPlayerSleepEvent.getVanillaProblem().equals((Object)Player.BedSleepingProblem.NOT_SAFE)) {
                canPlayerSleepEvent.setProblem(null);
            }
        }
    }

    @SubscribeEvent
    public static void blockToolModified(BlockEvent.BlockToolModificationEvent event) {
        LevelAccessor levelAccessor;
        if (((Boolean)Config.HOE_PLANTING_ENABLED.get()).booleanValue() && !event.isSimulated() && event.getItemAbility().equals(ItemAbilities.HOE_TILL) && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (event.getPlayer() != null && level.getBlockState(event.getPos().above()).canBeReplaced()) {
                ItemStack slotItem;
                ItemStack seedStack = ItemStack.EMPTY;
                if (event.getPlayer().getOffhandItem().is(Tags.Items.SEEDS)) {
                    seedStack = event.getPlayer().getOffhandItem();
                    event.getPlayer().swing(InteractionHand.OFF_HAND);
                } else {
                    for (int i = 0; i <= 9; ++i) {
                        slotItem = event.getPlayer().getInventory().getItem(i);
                        if (slotItem.isEmpty() || !slotItem.is(Tags.Items.SEEDS)) continue;
                        seedStack = slotItem;
                        event.getPlayer().swing(InteractionHand.MAIN_HAND);
                        break;
                    }
                }
                if (!seedStack.isEmpty() && !seedStack.is(Utilitarian.BLACKLISTED_SEEDS) && (slotItem = seedStack.getItem()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)slotItem;
                    ItemStack usedSeedStack = seedStack;
                    BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                    executor.tell((Runnable)new TickTask(0, () -> {
                        if (!usedSeedStack.isEmpty() && level.getBlockState(event.getPos()).getBlock() instanceof FarmBlock) {
                            BlockHitResult hitResult = new BlockHitResult(Vec3.ZERO, Direction.UP, event.getPos(), false);
                            InteractionResult blockState = blockItem.place(new BlockPlaceContext((Level)level, event.getPlayer(), event.getContext().getHand(), usedSeedStack, hitResult));
                            if (blockState.consumesAction() && !event.getPlayer().isCreative()) {
                                usedSeedStack.shrink(1);
                            }
                        }
                    }));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSystemMessage(ClientChatReceivedEvent.System event) {
        if (((Boolean)Config.NO_STARTUP_MESSAGES_ENABLED.get()).booleanValue()) {
            ((List)Config.NO_STARTUP_MESSAGES_MESSAGE_STRINGS.get()).forEach(s -> {
                if (event.getMessage().getString().contains((CharSequence)s)) {
                    Utilitarian.LOGGER.debug("Blocked message: \"" + event.getMessage().getString() + "\"");
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (((Boolean)Config.NO_TRAMPLE_ENABLED.get()).booleanValue() && !event.getEntity().getType().is(Utilitarian.TRAMPLING_ENTITIES)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBoneMeal(BonemealEvent event) {
        if (((Boolean)Config.FLOWER_DUPLICATION_ENABLED.get()).booleanValue() && event.getState().is(BlockTags.SMALL_FLOWERS)) {
            if (!event.getLevel().isClientSide) {
                if (event.getPlayer() != null) {
                    event.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                }
                event.getLevel().levelEvent(2011, event.getPos(), 15);
                Block.popResource((Level)event.getLevel(), (BlockPos)event.getPos(), (ItemStack)event.getState().getBlock().getCloneItemStack(event.getState(), (HitResult)new BlockHitResult(event.getPos().getCenter(), Direction.DOWN, event.getPos(), false), (LevelReader)event.getLevel(), event.getPos(), event.getPlayer()));
                event.getStack().shrink(1);
            }
            event.setSuccessful(true);
        }
    }

    @SubscribeEvent
    public static void chunkWatch(ChunkWatchEvent.Sent event) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)event.getLevel(), (ChunkPos)event.getPos(), (CustomPacketPayload)new SyncSoundMufflerData((List)event.getChunk().getData(Utilitarian.SOUND_MUFFLER_BLOCK_LIST), event.getPos().getWorldPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingDamageEvent.Post event) {
        LivingEntity livingEntity;
        if (event.getEntity().level() instanceof ServerLevel && (livingEntity = event.getEntity()) instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            if (event.getSource().is(DamageTypes.FALLING_ANVIL) && !villager.getVillagerData().getProfession().equals((Object)VillagerProfession.NITWIT)) {
                villager.setVillagerData(villager.getVillagerData().setProfession(VillagerProfession.NITWIT));
                villager.releasePoi(MemoryModuleType.JOB_SITE);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        Slime slime;
        Villager villager;
        Entity entity;
        if (event.getItemStack().is(Utilitarian.NITWIT_CONVERT) && (entity = event.getTarget()) instanceof Villager && (villager = (Villager)entity).getVillagerData().getProfession().equals((Object)VillagerProfession.NITWIT)) {
            villager.setVillagerData(villager.getVillagerData().setProfession(VillagerProfession.NONE));
        }
        if (!event.getLevel().isClientSide && event.getItemStack().is(Items.BUCKET) && (entity = event.getTarget()) instanceof Slime && (slime = (Slime)entity).getSize() == 1) {
            event.getItemStack().shrink(1);
            event.getEntity().addItem(((Item)UtilityItemModule.SLIME_BUCKET.get()).getDefaultInstance());
            event.getTarget().discard();
        }
    }

    private static /* synthetic */ void lambda$onEntitySpawn$0(ServerLevel serverLevel, EntityJoinLevelEvent event, LivingEntity entity) {
        List<BlockPos> nearbySoliciting = Helper.locateNearbySoliciting(serverLevel, event.getEntity().blockPosition());
        if (!nearbySoliciting.isEmpty()) {
            BlockPos pos = nearbySoliciting.getFirst();
            entity.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            if (serverLevel.getBlockState(pos).is(NoSolicitingModule.TRAPPED_SOLICITING_CARPETS)) {
                entity.kill();
            }
        } else {
            int nearbyNoSolicitingCount = Helper.locateNearbyNoSoliciting(serverLevel, event.getEntity().blockPosition());
            if (nearbyNoSolicitingCount > 0) {
                entity.discard();
            }
        }
    }
}

