/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import cy.jdkdigital.utilitarian.Utilitarian;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import cy.jdkdigital.utilitarian.network.SyncSoundMufflerData;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.PacketDistributor;

public class SoundMufflerBlock
extends Block {
    public SoundMufflerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.syncToClient(serverLevel, pos);
        }
    }

    private void syncToClient(ServerLevel serverLevel, BlockPos pos) {
        LevelChunk chunk = serverLevel.getChunkAt(pos);
        ArrayList<String> mufflerData = new ArrayList<String>((Collection)chunk.getData(Utilitarian.SOUND_MUFFLER_BLOCK_LIST));
        mufflerData.removeIf(s -> !serverLevel.getBlockState(BlockPos.of((long)Long.parseLong(s))).is(UtilityBlockModule.SOUND_MUFFLER));
        mufflerData.add(String.valueOf(pos.asLong()));
        chunk.setData(Utilitarian.SOUND_MUFFLER_BLOCK_LIST, mufflerData);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SyncSoundMufflerData(mufflerData, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

