/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DefaultGridBalanceHandler
implements GridBalanceHandler<AbstractContainerMenu> {
    @Override
    public void balanceGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return;
        }
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            int slotIndex = ((Slot)menu.slots.get(i)).getContainerSlot();
            ItemStack itemStack = craftMatrix.getItem(slotIndex);
            if (itemStack.isEmpty() || itemStack.getMaxStackSize() <= 1) continue;
            ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
            Object key = Objects.toString(registryName);
            DataComponentPatch componentsPatch = itemStack.getComponentsPatch();
            if (!componentsPatch.isEmpty()) {
                key = (String)key + "@" + String.valueOf(componentsPatch);
            }
            itemMap.put(key, (Object)itemStack);
            itemCount.add(key, itemStack.getCount());
        }
        for (String key : itemMap.keySet()) {
            List balanceList = itemMap.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / balanceList.size();
            int restCount = totalCount % balanceList.size();
            for (ItemStack itemStack : balanceList) {
                itemStack.setCount(countPerStack);
            }
            int idx = 0;
            while (restCount > 0) {
                ItemStack itemStack;
                itemStack = (ItemStack)balanceList.get(idx);
                if (itemStack.getCount() < itemStack.getMaxStackSize()) {
                    itemStack.grow(1);
                    --restCount;
                }
                if (++idx < balanceList.size()) continue;
                idx = 0;
            }
        }
        menu.broadcastChanges();
    }

    @Override
    public void spreadGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu) {
        boolean emptyBiggestSlot;
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return;
        }
        do {
            ItemStack biggestSlotStack = null;
            int biggestSlotSize = 1;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)menu.slots.get(i)).getContainerSlot();
                ItemStack itemStack = craftMatrix.getItem(slotIndex);
                if (itemStack.isEmpty() || itemStack.getCount() <= biggestSlotSize) continue;
                biggestSlotStack = itemStack;
                biggestSlotSize = itemStack.getCount();
            }
            if (biggestSlotStack == null) {
                return;
            }
            emptyBiggestSlot = false;
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((Slot)menu.slots.get(i)).getContainerSlot();
                ItemStack itemStack = craftMatrix.getItem(slotIndex);
                if (!itemStack.isEmpty()) continue;
                if (biggestSlotStack.getCount() > 1) {
                    craftMatrix.setItem(slotIndex, biggestSlotStack.split(1));
                    continue;
                }
                emptyBiggestSlot = true;
            }
        } while (emptyBiggestSlot);
        this.balanceGrid(grid, player, menu);
    }
}

