/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.ifwootaddon.upgrades;

import com.buuz135.industrial.item.LaserLensItem;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.hrznstudio.titanium.util.RecipeUtil;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.interfaces.WootUpgradeEnum;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.ifwootaddon.IFWootAddon;
import wootrevived.ifwootaddon.components.LaserDrillData;
import wootrevived.ifwootaddon.mixins.LaserLensItemMixin;
import wootrevived.ifwootaddon.registries.ComponentsRegistry;

public class LaserDrill
extends WootUpgradeItem<Variant> {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"ifwootaddon");
    public static final String LASER_DRILL_TAG = "laser_drill_upgrade";
    public static final DeferredHolder<Item, LaserDrill> LASER_DRILL_ITEM = ITEMS.register("laser_drill_upgrade", LaserDrill::new);

    public LaserDrill() {
        super(new Item.Properties().component((DataComponentType)ComponentsRegistry.LASER_DRILL_DATA.get(), (Object)LaserDrillData.empty()), (Enum)Variant.DEFAULT);
    }

    public void modifyDrops(@NotNull WootDropsProperties properties, @NotNull MutableDataComponentHolder dataComponentHolder) {
        ItemStack lens;
        Variant variant = (Variant)this.getVariant(dataComponentHolder);
        if (variant == Variant.DEFAULT) {
            lens = LaserDrillData.get((LaserDrillData.Component)dataComponentHolder.get((DataComponentType)ComponentsRegistry.LASER_DRILL_DATA.get()));
            if (lens.isEmpty()) {
                return;
            }
        } else {
            LaserLensItem item = (LaserLensItem)ModuleCore.LASER_LENS[variant.id()].get();
            lens = item.getDefaultInstance();
        }
        List fluids = properties.getFluidDrops();
        List fluidRecipes = RecipeUtil.getRecipes((Level)properties.getLevel(), (RecipeType)((RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get()));
        for (LaserDrillFluidRecipe recipe : fluidRecipes) {
            if (!recipe.catalyst.test(lens) || recipe.entity.equals((Object)LaserDrillFluidRecipe.EMPTY) || !recipe.entity.equals((Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)properties.getFactoryMob().getEntityType()))) continue;
            fluids.add(recipe.output.copy());
        }
    }

    @NotNull
    public ItemInteractionResult interact(@NotNull MutableDataComponentHolder dataComponentHolder, @NotNull ItemStack stack, @NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        List fluidRecipes = RecipeUtil.getRecipes((Level)level, (RecipeType)((RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get()));
        LaserDrillFluidRecipe recipe = fluidRecipes.stream().filter(r -> r.catalyst.test(stack)).findFirst().orElse(null);
        if (recipe == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item item = stack.getItem();
        if (item instanceof LaserLensItem) {
            LaserLensItem item2 = (LaserLensItem)item;
            dataComponentHolder.set((DataComponentType)ComponentsRegistry.LASER_DRILL_DATA.get(), (Object)LaserDrillData.empty());
            this.setVariant(dataComponentHolder, Variant.byId(((LaserLensItemMixin)item2).woot$getColor().getId()));
        } else {
            dataComponentHolder.set((DataComponentType)ComponentsRegistry.LASER_DRILL_DATA.get(), (Object)LaserDrillData.of(stack));
            this.setVariant(dataComponentHolder, Variant.DEFAULT);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        Variant variant = (Variant)this.getVariant((MutableDataComponentHolder)stack);
        if (variant != Variant.DEFAULT) {
            LaserLensItem item = (LaserLensItem)ModuleCore.LASER_LENS[variant.id()].get();
            tooltip.add((Component)item.getName(stack).copy().withStyle(variant.getColorStyle()));
        } else {
            ItemStack lens = LaserDrillData.get((LaserDrillData.Component)stack.get((DataComponentType)ComponentsRegistry.LASER_DRILL_DATA.get()));
            if (!lens.isEmpty()) {
                tooltip.add((Component)lens.getHoverName().copy().withStyle(variant.getColorStyle()));
            }
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Variant variant) {
        return IFWootAddon.location("textures/item/laser_drill_upgrade/" + variant.getSerializedName() + ".png");
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(LASER_DRILL_ITEM, Variant.class);
    }

    public static enum Variant implements WootUpgradeEnum<Variant>
    {
        WHITE(0, "white", DyeColor.WHITE),
        ORANGE(1, "orange", DyeColor.ORANGE),
        MAGENTA(2, "magenta", DyeColor.MAGENTA),
        LIGHT_BLUE(3, "light_blue", DyeColor.LIGHT_BLUE),
        YELLOW(4, "yellow", DyeColor.YELLOW),
        LIME(5, "lime", DyeColor.LIME),
        PINK(6, "pink", DyeColor.PINK),
        GRAY(7, "gray", DyeColor.GRAY),
        LIGHT_GRAY(8, "light_gray", DyeColor.LIGHT_GRAY),
        CYAN(9, "cyan", DyeColor.CYAN),
        PURPLE(10, "purple", DyeColor.PURPLE),
        BLUE(11, "blue", DyeColor.BLUE),
        BROWN(12, "brown", DyeColor.BROWN),
        GREEN(13, "green", DyeColor.GREEN),
        RED(14, "red", DyeColor.RED),
        BLACK(15, "black", DyeColor.BLACK),
        DEFAULT(16, "default", null);

        private static final IntFunction<Variant> BY_ID;
        private static final Codec<Variant> CODEC;
        private final int id;
        private final String name;
        @Nullable
        private final DyeColor color;

        private Variant(@Nullable int id, String name, DyeColor color) {
            this.id = id;
            this.name = name;
            this.color = color;
        }

        public int id() {
            return this.id;
        }

        public Style getColorStyle() {
            return Style.EMPTY.withColor(this.color != null ? TextColor.fromRgb((int)this.color.getTextColor()) : TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY));
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public Codec<Variant> codec() {
            return CODEC;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::id, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Variant::values);
        }
    }
}

