/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.ifwootaddon.datagen;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;
import wootrevived.ifwootaddon.datagen.languages.English;
import wootrevived.ifwootaddon.datagen.languages.SimplifiedChinese;

public class Languages
implements DataProvider {
    private final List<? extends LanguageProvider> languages;

    public Languages(PackOutput packOutput) {
        this.languages = List.of(new English(packOutput), new SimplifiedChinese(packOutput));
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (LanguageProvider languageProvider : this.languages) {
            futures.add(languageProvider.run(cache));
        }
        return CompletableFuture.runAsync(() -> {
            for (CompletableFuture future : futures) {
                future.join();
            }
        }, Util.backgroundExecutor());
    }

    public String getName() {
        return "Languages";
    }
}

