/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.ifwootaddon.datagen;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import wootrevived.api.models.DynamicUpgradeItemModelBuilder;
import wootrevived.ifwootaddon.registries.IFItemsRegistry;
import wootrevived.ifwootaddon.upgrades.LaserDrill;
import wootrevived.ifwootaddon.upgrades.MobCrusher;
import wootrevived.ifwootaddon.upgrades.MobSlaughterFactory;

public class Items
extends ItemModelProvider {
    public Items(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "ifwootaddon", existingFileHelper);
    }

    protected void registerModels() {
        this.itemGenerated(MobCrusher.MOB_CRUSHER_ITEM);
        this.itemGenerated(MobSlaughterFactory.MOB_SLAUGHTER_FACTORY_ITEM);
        this.itemUpgrade(LaserDrill.LASER_DRILL_ITEM);
        this.itemGenerated(IFItemsRegistry.STYGIAN_LASER_LENS_ITEM);
    }

    public ResourceLocation getItemResource(Item item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).withPrefix("item/");
    }

    public void itemGenerated(DeferredHolder<Item, ? extends Item> item) {
        ResourceLocation itemResource = this.getItemResource((Item)item.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemResource.getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", itemResource);
    }

    public void itemUpgrade(DeferredHolder<Item, ? extends Item> item) {
        ResourceLocation itemResource = this.getItemResource((Item)item.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemResource.getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).customLoader(DynamicUpgradeItemModelBuilder::begin);
    }
}

