/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.features;

import java.util.List;
import net.luckystudio.spelunkers_charm.block.custom.HangingBlock;
import net.luckystudio.spelunkers_charm.block.util.ModBlockStateProperties;
import net.luckystudio.spelunkers_charm.block.util.enums.GeyserType;
import net.luckystudio.spelunkers_charm.datagen.blockTags.ModBlockTags;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.luckystudio.spelunkers_charm.init.ModFeature;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.directional_block.DirectionalBlockFeatureConfiguration;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.geyser.GeyserConfiguration;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.large_icicle.LargeIcicleFeatureConfiguration;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.packed_ice_cluster.IcicleClusterConfiguration;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.replace.ReplaceMultiBlockSphereConfiguration;
import net.luckystudio.spelunkers_charm.worldgen.util.ModFeatureUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SculkPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.jetbrains.annotations.NotNull;

public class ModCaveFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> CLAY_PILE = ModFeatureUtils.createKey("clay_pile");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROCK_PILE = ModFeatureUtils.createKey("rock_pile");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEEPSLATE_ROCK_PILE = ModFeatureUtils.createKey("deepslate_rock_pile");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DRIPSTONE_ROCK_PILE = ModFeatureUtils.createKey("dripstone_rock_pile");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_CAVE_MUSHROOM = ModFeatureUtils.createKey("patch_cave_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEEPSLATE_LAVA_GEYSER = ModFeatureUtils.createKey("deepslate_lava_geyser");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BOULDERS = ModFeatureUtils.createKey("boulders");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST = ModFeatureUtils.createKey("permafrost");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_COAL = ModFeatureUtils.createKey("permafrost_ore_coal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_COAL_BURIED = ModFeatureUtils.createKey("permafrost_ore_coal_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_IRON = ModFeatureUtils.createKey("permafrost_ore_iron");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_IRON_SMALL = ModFeatureUtils.createKey("permafrost_ore_iron_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_GOLD = ModFeatureUtils.createKey("permafrost_ore_gold");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_GOLD_BURIED = ModFeatureUtils.createKey("permafrost_ore_gold_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_REDSTONE = ModFeatureUtils.createKey("permafrost_ore_redstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_DIAMOND_SMALL = ModFeatureUtils.createKey("permafrost_ore_diamond_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_DIAMOND_MEDIUM = ModFeatureUtils.createKey("permafrost_ore_diamond_medium");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_DIAMOND_LARGE = ModFeatureUtils.createKey("permafrost_ore_diamond_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_DIAMOND_BURIED = ModFeatureUtils.createKey("permafrost_ore_diamond_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_LAPIS = ModFeatureUtils.createKey("permafrost_ore_lapis");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_LAPIS_BURIED = ModFeatureUtils.createKey("permafrost_ore_lapis_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_EMERALD = ModFeatureUtils.createKey("permafrost_ore_emerald");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PERMAFROST_ORE_COPPER_SMALL = ModFeatureUtils.createKey("permafrost_ore_copper_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_SILT = ModFeatureUtils.createKey("ore_silt");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_PILE = ModFeatureUtils.createKey("ice_pile");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_ICICLE = ModFeatureUtils.createKey("large_icicle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICICLE_CLUSTER = ModFeatureUtils.createKey("icicle_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BOTTOM_ICE_SHEET = ModFeatureUtils.createKey("bottom_ice_sheet");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE = ModFeatureUtils.createKey("dunestone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_COAL = ModFeatureUtils.createKey("dunestone_ore_coal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_COAL_BURIED = ModFeatureUtils.createKey("dunestone_ore_coal_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_IRON = ModFeatureUtils.createKey("dunestone_ore_iron");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_IRON_SMALL = ModFeatureUtils.createKey("dunestone_ore_iron_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_GOLD = ModFeatureUtils.createKey("dunestone_ore_gold");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_GOLD_BURIED = ModFeatureUtils.createKey("dunestone_ore_gold_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_REDSTONE = ModFeatureUtils.createKey("dunestone_ore_redstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_DIAMOND_SMALL = ModFeatureUtils.createKey("dunestone_ore_diamond_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_DIAMOND_MEDIUM = ModFeatureUtils.createKey("dunestone_ore_diamond_medium");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_DIAMOND_LARGE = ModFeatureUtils.createKey("dunestone_ore_diamond_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_DIAMOND_BURIED = ModFeatureUtils.createKey("dunestone_ore_diamond_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_LAPIS = ModFeatureUtils.createKey("dunestone_ore_lapis");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_LAPIS_BURIED = ModFeatureUtils.createKey("dunestone_ore_lapis_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_EMERALD = ModFeatureUtils.createKey("dunestone_ore_emerald");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_COPPER_SMALL = ModFeatureUtils.createKey("dunestone_ore_copper_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNESTONE_ORE_COPPER_LARGE = ModFeatureUtils.createKey("dunestone_ore_copper_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE = ModFeatureUtils.createKey("wildstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_COAL = ModFeatureUtils.createKey("wildstone_ore_coal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_COAL_BURIED = ModFeatureUtils.createKey("wildstone_ore_coal_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_IRON = ModFeatureUtils.createKey("wildstone_ore_iron");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_IRON_SMALL = ModFeatureUtils.createKey("wildstone_ore_iron_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_GOLD = ModFeatureUtils.createKey("wildstone_ore_gold");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_GOLD_BURIED = ModFeatureUtils.createKey("wildstone_ore_gold_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_REDSTONE = ModFeatureUtils.createKey("wildstone_ore_redstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_DIAMOND_SMALL = ModFeatureUtils.createKey("wildstone_ore_diamond_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_DIAMOND_MEDIUM = ModFeatureUtils.createKey("wildstone_ore_diamond_medium");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_DIAMOND_LARGE = ModFeatureUtils.createKey("wildstone_ore_diamond_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_DIAMOND_BURIED = ModFeatureUtils.createKey("wildstone_ore_diamond_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_LAPIS = ModFeatureUtils.createKey("wildstone_ore_lapis");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_LAPIS_BURIED = ModFeatureUtils.createKey("wildstone_ore_lapis_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_EMERALD = ModFeatureUtils.createKey("wildstone_ore_emerald");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDSTONE_ORE_COPPER_SMALL = ModFeatureUtils.createKey("wildstone_ore_copper_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HANGING_WEB = ModFeatureUtils.createKey("hanging_web");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIDER_CAVE_PATCH_CEILING = ModFeatureUtils.createKey("spider_cave_patch_ceiling");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEB_PATCH = ModFeatureUtils.createKey("web_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEB_VEIN = ModFeatureUtils.createKey("web_vein");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIDER_EGG = ModFeatureUtils.createKey("spider_egg");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BASALT_ROCK_PILE = ModFeatureUtils.createKey("basalt_rock_pile");
    static List<Block> generalOverworldBlocks = List.of(Blocks.STONE, Blocks.GRANITE, Blocks.DIORITE, Blocks.ANDESITE, Blocks.DRIPSTONE_BLOCK);
    static List<Block> generalNetherBlocks = List.of(Blocks.NETHERRACK, Blocks.BASALT, Blocks.BLACKSTONE);

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest ruleOverworld = new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD);
        TagMatchTest ruletest = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        HolderGetter holderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        ModCaveFeatures.rockFeature((Block)ModBlocks.CLAY_PILE.get(), CLAY_PILE, context, generalOverworldBlocks);
        ModCaveFeatures.rockFeature((Block)ModBlocks.ROCK.get(), ROCK_PILE, context, generalOverworldBlocks);
        ModCaveFeatures.rockFeature((Block)ModBlocks.DEEPSLATE_ROCK.get(), DEEPSLATE_ROCK_PILE, context, List.of(Blocks.DEEPSLATE));
        ModCaveFeatures.rockFeature((Block)ModBlocks.DRIPSTONE_ROCK.get(), DRIPSTONE_ROCK_PILE, context, List.of(Blocks.DRIPSTONE_BLOCK, (Block)ModBlocks.DUNESTONE.get()));
        FeatureUtils.register(context, PATCH_CAVE_MUSHROOM, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.CAVE_MUSHROOM.get()))), generalOverworldBlocks));
        FeatureUtils.register(context, DEEPSLATE_LAVA_GEYSER, ModFeature.GEYSER.get(), (FeatureConfiguration)new GeyserConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.DEEPSLATE_GEYSER.get()).defaultBlockState().setValue(ModBlockStateProperties.GEYSER_TYPE, (Comparable)((Object)GeyserType.LAVA)))), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.DEEPSLATE), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.LAVA)));
        FeatureUtils.register(context, BOULDERS, ModFeature.BOULDER.get(), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE);
        ModCaveFeatures.stoneSpecificBiomeFeature(context, PERMAFROST, (Block)ModBlocks.PERMAFROST.get(), ModBlockTags.PERMAFROST_REPLACEABLE);
        FeatureUtils.register(context, PERMAFROST_ORE_COAL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_COAL_ORE.get()).defaultBlockState(), 17));
        FeatureUtils.register(context, PERMAFROST_ORE_COAL_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_COAL_ORE.get()).defaultBlockState(), 17, 0.5f));
        FeatureUtils.register(context, PERMAFROST_ORE_IRON, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_IRON_ORE.get()).defaultBlockState(), 9));
        FeatureUtils.register(context, PERMAFROST_ORE_IRON_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_IRON_ORE.get()).defaultBlockState(), 4));
        FeatureUtils.register(context, PERMAFROST_ORE_GOLD, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_GOLD_ORE.get()).defaultBlockState(), 9));
        FeatureUtils.register(context, PERMAFROST_ORE_GOLD_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_GOLD_ORE.get()).defaultBlockState(), 9, 0.5f));
        FeatureUtils.register(context, PERMAFROST_ORE_REDSTONE, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_REDSTONE_ORE.get()).defaultBlockState(), 8));
        FeatureUtils.register(context, PERMAFROST_ORE_DIAMOND_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_DIAMOND_ORE.get()).defaultBlockState(), 4, 0.5f));
        FeatureUtils.register(context, PERMAFROST_ORE_DIAMOND_LARGE, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_DIAMOND_ORE.get()).defaultBlockState(), 12, 0.7f));
        FeatureUtils.register(context, PERMAFROST_ORE_DIAMOND_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_DIAMOND_ORE.get()).defaultBlockState(), 8, 1.0f));
        FeatureUtils.register(context, PERMAFROST_ORE_DIAMOND_MEDIUM, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_DIAMOND_ORE.get()).defaultBlockState(), 8, 0.5f));
        FeatureUtils.register(context, PERMAFROST_ORE_LAPIS, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_LAPIS_ORE.get()).defaultBlockState(), 7));
        FeatureUtils.register(context, PERMAFROST_ORE_LAPIS_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_LAPIS_ORE.get()).defaultBlockState(), 7, 1.0f));
        FeatureUtils.register(context, PERMAFROST_ORE_EMERALD, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_EMERALD_ORE.get()).defaultBlockState(), 3));
        FeatureUtils.register(context, PERMAFROST_ORE_COPPER_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.PERMAFROST_COPPER_ORE.get()).defaultBlockState(), 10));
        FeatureUtils.register(context, ORE_SILT, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruleOverworld, ((Block)ModBlocks.SILT.get()).defaultBlockState(), 32));
        ModCaveFeatures.rockFeature((Block)ModBlocks.ICE_BALL.get(), ICE_PILE, context, List.of((Block)ModBlocks.PERMAFROST.get(), Blocks.PACKED_ICE, Blocks.ICE));
        FeatureUtils.register(context, LARGE_ICICLE, ModFeature.LARGE_ICICLE.get(), (FeatureConfiguration)new LargeIcicleFeatureConfiguration(30, (IntProvider)UniformInt.of((int)3, (int)19), (FloatProvider)UniformFloat.of((float)0.4f, (float)2.0f), 0.33f, (FloatProvider)UniformFloat.of((float)0.3f, (float)0.9f), (FloatProvider)UniformFloat.of((float)0.4f, (float)1.0f), (FloatProvider)UniformFloat.of((float)0.0f, (float)0.3f), 4, 0.6f));
        FeatureUtils.register(context, ICICLE_CLUSTER, ModFeature.ICE_CLUSTER.get(), (FeatureConfiguration)new IcicleClusterConfiguration(12, (IntProvider)UniformInt.of((int)3, (int)6), (IntProvider)UniformInt.of((int)2, (int)8), 1, 3, (IntProvider)UniformInt.of((int)2, (int)4), (FloatProvider)UniformFloat.of((float)0.3f, (float)0.7f), (FloatProvider)ClampedNormalFloat.of((float)0.1f, (float)0.3f, (float)0.1f, (float)0.9f), 0.1f, 3, 8));
        FeatureUtils.register(context, BOTTOM_ICE_SHEET, (Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ICE)));
        ModCaveFeatures.stoneSpecificBiomeFeature(context, DUNESTONE, (Block)ModBlocks.DUNESTONE.get(), ModBlockTags.DUNESTONE_REPLACEABLE);
        FeatureUtils.register(context, DUNESTONE_ORE_COAL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_COAL_ORE.get()).defaultBlockState(), 17));
        FeatureUtils.register(context, DUNESTONE_ORE_COAL_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_COAL_ORE.get()).defaultBlockState(), 17, 0.5f));
        FeatureUtils.register(context, DUNESTONE_ORE_IRON, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_IRON_ORE.get()).defaultBlockState(), 9));
        FeatureUtils.register(context, DUNESTONE_ORE_IRON_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_IRON_ORE.get()).defaultBlockState(), 4));
        FeatureUtils.register(context, DUNESTONE_ORE_GOLD, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_GOLD_ORE.get()).defaultBlockState(), 9));
        FeatureUtils.register(context, DUNESTONE_ORE_GOLD_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_GOLD_ORE.get()).defaultBlockState(), 9, 0.5f));
        FeatureUtils.register(context, DUNESTONE_ORE_REDSTONE, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_REDSTONE_ORE.get()).defaultBlockState(), 8));
        FeatureUtils.register(context, DUNESTONE_ORE_DIAMOND_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_DIAMOND_ORE.get()).defaultBlockState(), 4, 0.5f));
        FeatureUtils.register(context, DUNESTONE_ORE_DIAMOND_LARGE, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_DIAMOND_ORE.get()).defaultBlockState(), 12, 0.7f));
        FeatureUtils.register(context, DUNESTONE_ORE_DIAMOND_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_DIAMOND_ORE.get()).defaultBlockState(), 8, 1.0f));
        FeatureUtils.register(context, DUNESTONE_ORE_DIAMOND_MEDIUM, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_DIAMOND_ORE.get()).defaultBlockState(), 8, 0.5f));
        FeatureUtils.register(context, DUNESTONE_ORE_LAPIS, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_LAPIS_ORE.get()).defaultBlockState(), 7));
        FeatureUtils.register(context, DUNESTONE_ORE_LAPIS_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_LAPIS_ORE.get()).defaultBlockState(), 7, 1.0f));
        FeatureUtils.register(context, DUNESTONE_ORE_EMERALD, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_EMERALD_ORE.get()).defaultBlockState(), 3));
        FeatureUtils.register(context, DUNESTONE_ORE_COPPER_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_COPPER_ORE.get()).defaultBlockState(), 10));
        FeatureUtils.register(context, DUNESTONE_ORE_COPPER_LARGE, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.DUNESTONE_COPPER_ORE.get()).defaultBlockState(), 20));
        ModCaveFeatures.stoneSpecificBiomeFeature(context, WILDSTONE, (Block)ModBlocks.WILDSTONE.get(), ModBlockTags.WILDSTONE_REPLACEABLE);
        FeatureUtils.register(context, WILDSTONE_ORE_COAL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_COAL_ORE.get()).defaultBlockState(), 17));
        FeatureUtils.register(context, WILDSTONE_ORE_COAL_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_COAL_ORE.get()).defaultBlockState(), 17, 0.5f));
        FeatureUtils.register(context, WILDSTONE_ORE_IRON, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_IRON_ORE.get()).defaultBlockState(), 9));
        FeatureUtils.register(context, WILDSTONE_ORE_IRON_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_IRON_ORE.get()).defaultBlockState(), 4));
        FeatureUtils.register(context, WILDSTONE_ORE_GOLD, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_GOLD_ORE.get()).defaultBlockState(), 9));
        FeatureUtils.register(context, WILDSTONE_ORE_GOLD_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_GOLD_ORE.get()).defaultBlockState(), 9, 0.5f));
        FeatureUtils.register(context, WILDSTONE_ORE_REDSTONE, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_REDSTONE_ORE.get()).defaultBlockState(), 8));
        FeatureUtils.register(context, WILDSTONE_ORE_DIAMOND_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_DIAMOND_ORE.get()).defaultBlockState(), 4, 0.5f));
        FeatureUtils.register(context, WILDSTONE_ORE_DIAMOND_LARGE, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_DIAMOND_ORE.get()).defaultBlockState(), 12, 0.7f));
        FeatureUtils.register(context, WILDSTONE_ORE_DIAMOND_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_DIAMOND_ORE.get()).defaultBlockState(), 8, 1.0f));
        FeatureUtils.register(context, WILDSTONE_ORE_DIAMOND_MEDIUM, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_DIAMOND_ORE.get()).defaultBlockState(), 8, 0.5f));
        FeatureUtils.register(context, WILDSTONE_ORE_LAPIS, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_LAPIS_ORE.get()).defaultBlockState(), 7));
        FeatureUtils.register(context, WILDSTONE_ORE_LAPIS_BURIED, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_LAPIS_ORE.get()).defaultBlockState(), 7, 1.0f));
        FeatureUtils.register(context, WILDSTONE_ORE_EMERALD, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_EMERALD_ORE.get()).defaultBlockState(), 3));
        FeatureUtils.register(context, WILDSTONE_ORE_COPPER_SMALL, ModFeature.MOD_ORE_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)ModBlocks.WILDSTONE_COPPER_ORE.get()).defaultBlockState(), 10));
        FeatureUtils.register(context, HANGING_WEB, (Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)UniformInt.of((int)0, (int)3), 5).add((Object)UniformInt.of((int)1, (int)7), 1).build()), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.HANGING_WEB.get()).defaultBlockState().setValue((Property)HangingBlock.END, (Comparable)Boolean.valueOf(false))))), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.HANGING_WEB.get()).defaultBlockState().setValue((Property)HangingBlock.END, (Comparable)Boolean.valueOf(true)))))), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true));
        FeatureUtils.register(context, SPIDER_CAVE_PATCH_CEILING, (Feature)Feature.VEGETATION_PATCH, (FeatureConfiguration)new VegetationPatchConfiguration(BlockTags.BASE_STONE_OVERWORLD, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.PACKED_WEB.get())), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(HANGING_WEB), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.CEILING, (IntProvider)UniformInt.of((int)1, (int)2), 0.0f, 5, 0.08f, (IntProvider)UniformInt.of((int)4, (int)7), 0.3f));
        FeatureUtils.register(context, WEB_PATCH, ModFeature.WEB_PATCH.get(), (FeatureConfiguration)new SculkPatchConfiguration(10, 32, 64, 0, 1, (IntProvider)ConstantInt.of((int)0), 0.5f));
        MultifaceBlock webVein = (MultifaceBlock)ModBlocks.WEB_VEIN.get();
        FeatureUtils.register(context, WEB_VEIN, (Feature)Feature.MULTIFACE_GROWTH, (FeatureConfiguration)new MultifaceGrowthConfiguration(webVein, 20, true, true, true, 1.0f, (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{Blocks.STONE, Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.DRIPSTONE_BLOCK, Blocks.CALCITE, Blocks.TUFF, Blocks.DEEPSLATE})));
        FeatureUtils.register(context, SPIDER_EGG, ModFeature.DIRECTIONAL_BLOCK.get(), (FeatureConfiguration)new DirectionalBlockFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.SPIDER_EGG.get())), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.PACKED_WEB.get()))));
        ModCaveFeatures.rockFeature((Block)ModBlocks.BASALT_ROCK.get(), BASALT_ROCK_PILE, context, generalNetherBlocks);
    }

    private static void stoneSpecificBiomeFeature(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> stoneFeatureKey, Block newStone, TagKey<Block> blocksToReplace) {
        FeatureUtils.register(context, stoneFeatureKey, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration(ModFeature.REPLACE_MULTI_BLOCK_BLOB_WITH_CONFIG.get(), (FeatureConfiguration)new ReplaceMultiBlockSphereConfiguration(newStone.defaultBlockState(), blocksToReplace, (IntProvider)UniformInt.of((int)4, (int)8))));
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider stateProvider, int tries) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)tries, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(stateProvider)));
    }

    private static void rockFeature(Block block, ResourceKey<ConfiguredFeature<?, ?>> rockKey, BootstrapContext<ConfiguredFeature<?, ?>> context, List<@NotNull Block> blocks) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 3; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.add((Object)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)ModBlockStateProperties.ROCKS, (Comparable)Integer.valueOf(i))).setValue((Property)PinkPetalsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        FeatureUtils.register(context, rockKey, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder)), blocks));
    }
}

