/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.web_patch;

import com.mojang.serialization.Codec;
import net.luckystudio.spelunkers_charm.block.custom.web_vein.WebSpreader;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SculkPatchConfiguration;

public class WebPatchFeature
extends Feature<SculkPatchConfiguration> {
    public WebPatchFeature(Codec<SculkPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SculkPatchConfiguration> context) {
        BlockPos blockpos;
        WorldGenLevel worldgenlevel = context.level();
        if (!this.canSpreadFrom((LevelAccessor)worldgenlevel, blockpos = context.origin())) {
            return false;
        }
        SculkPatchConfiguration sculkpatchconfiguration = (SculkPatchConfiguration)context.config();
        RandomSource randomsource = context.random();
        WebSpreader worldGenSpreader = WebSpreader.createWorldGenSpreader();
        int i = sculkpatchconfiguration.spreadRounds() + sculkpatchconfiguration.growthRounds();
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < sculkpatchconfiguration.chargeCount(); ++k) {
                worldGenSpreader.addCursors(blockpos, sculkpatchconfiguration.amountPerCharge());
            }
            boolean flag = j < sculkpatchconfiguration.spreadRounds();
            for (int l = 0; l < sculkpatchconfiguration.spreadAttempts(); ++l) {
                worldGenSpreader.updateCursors((LevelAccessor)worldgenlevel, blockpos, randomsource, flag);
            }
            worldGenSpreader.clear();
        }
        BlockPos blockpos2 = blockpos.below();
        if (randomsource.nextFloat() <= sculkpatchconfiguration.catalystChance() && worldgenlevel.getBlockState(blockpos2).isCollisionShapeFullBlock((BlockGetter)worldgenlevel, blockpos2)) {
            worldgenlevel.setBlock(blockpos, ((Block)ModBlocks.SPIDER_EGG.get()).defaultBlockState(), 3);
        }
        int i1 = sculkpatchconfiguration.extraRareGrowths().sample(randomsource);
        for (int j1 = 0; j1 < i1; ++j1) {
            BlockPos blockpos1 = blockpos.offset(randomsource.nextInt(5) - 2, 0, randomsource.nextInt(5) - 2);
            if (!worldgenlevel.getBlockState(blockpos1).isAir() || !worldgenlevel.getBlockState(blockpos1.below()).isFaceSturdy((BlockGetter)worldgenlevel, blockpos1.below(), Direction.UP)) continue;
            worldgenlevel.setBlock(blockpos1, ((Block)ModBlocks.SPIDER_EGG.get()).defaultBlockState(), 3);
        }
        return true;
    }

    private boolean canSpreadFrom(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.getBlock() instanceof SculkBehaviour) {
            return true;
        }
        return !blockstate.isAir() && (!blockstate.is(Blocks.WATER) || !blockstate.getFluidState().isSource()) ? false : Direction.stream().map(arg_0 -> ((BlockPos)pos).relative(arg_0)).anyMatch(p_225245_ -> level.getBlockState(p_225245_).isCollisionShapeFullBlock((BlockGetter)level, p_225245_));
    }
}

