/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.icicle;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.icicle.IcicleBlockUtil;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.icicle.IcicleConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class PointedBlockFeature
extends Feature<IcicleConfiguration> {
    public PointedBlockFeature(Codec<IcicleConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<IcicleConfiguration> context) {
        WorldGenLevel levelaccessor = context.level();
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        IcicleConfiguration IcicleConfiguration2 = (IcicleConfiguration)context.config();
        Optional<Direction> optional = PointedBlockFeature.getTipDirection((LevelAccessor)levelaccessor, blockpos, randomsource);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockpos1 = blockpos.relative(optional.get().getOpposite());
        PointedBlockFeature.createPatchOfDripstoneBlocks((LevelAccessor)levelaccessor, randomsource, blockpos1, IcicleConfiguration2);
        int i = randomsource.nextFloat() < IcicleConfiguration2.chanceOfTallerDripstone && IcicleBlockUtil.isEmptyOrWater(levelaccessor.getBlockState(blockpos.relative(optional.get()))) ? 2 : 1;
        IcicleBlockUtil.growPointedIcicle((LevelAccessor)levelaccessor, blockpos, optional.get(), i, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor level, BlockPos pos, RandomSource random) {
        boolean flag = IcicleBlockUtil.isIcicleBase(level.getBlockState(pos.above()));
        boolean flag1 = IcicleBlockUtil.isIcicleBase(level.getBlockState(pos.below()));
        if (flag && flag1) {
            return Optional.of(random.nextBoolean() ? Direction.DOWN : Direction.UP);
        }
        if (flag) {
            return Optional.of(Direction.DOWN);
        }
        return flag1 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfDripstoneBlocks(LevelAccessor level, RandomSource random, BlockPos pos, IcicleConfiguration config) {
        IcicleBlockUtil.placeIcicleBlockIfPossible(level, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (random.nextFloat() > config.chanceOfDirectionalSpread) continue;
            BlockPos blockpos = pos.relative(direction);
            IcicleBlockUtil.placeIcicleBlockIfPossible(level, blockpos);
            if (random.nextFloat() > config.chanceOfSpreadRadius2) continue;
            BlockPos blockpos1 = blockpos.relative(Direction.getRandom((RandomSource)random));
            IcicleBlockUtil.placeIcicleBlockIfPossible(level, blockpos1);
            if (random.nextFloat() > config.chanceOfSpreadRadius3) continue;
            BlockPos blockpos2 = blockpos1.relative(Direction.getRandom((RandomSource)random));
            IcicleBlockUtil.placeIcicleBlockIfPossible(level, blockpos2);
        }
    }
}

