/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.ice_pool;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.ice_pool.IceSheetConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class IceSheetFeature
extends Feature<IceSheetConfiguration> {
    public IceSheetFeature(Codec<IceSheetConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<IceSheetConfiguration> context) {
        WorldGenLevel worldgenlevel = context.level();
        IceSheetConfiguration config = (IceSheetConfiguration)context.config();
        RandomSource randomsource = context.random();
        BlockPos blockpos = context.origin();
        Predicate<BlockState> predicate = p_204782_ -> p_204782_.is(config.replaceable);
        int i = config.xzRadius.sample(randomsource) + 1;
        int j = config.xzRadius.sample(randomsource) + 1;
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel level) {
        HashSet<BlockPos> set1 = new HashSet<BlockPos>();
        for (BlockPos blockpos1 : set1) {
            level.setBlock(blockpos1, Blocks.ICE.defaultBlockState(), 2);
        }
        return set1;
    }
}

