/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom.directional_block;

import com.mojang.serialization.Codec;
import net.luckystudio.spelunkers_charm.worldgen.feature.custom.directional_block.DirectionalBlockFeatureConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class DirectionalBlockFeature
extends Feature<DirectionalBlockFeatureConfiguration> {
    public DirectionalBlockFeature(Codec<DirectionalBlockFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<DirectionalBlockFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        DirectionalBlockFeatureConfiguration config = (DirectionalBlockFeatureConfiguration)context.config();
        BlockState blockStateProvider = config.blockStateProvider.getState(RandomSource.create(), origin);
        BlockState supportingBlockStateProvider = config.supportingBlockProvider.getState(RandomSource.create(), origin);
        int placed = 0;
        block0: for (int i = 0; i < 64; ++i) {
            BlockPos pos = origin.offset(random.nextInt(8) - 4, random.nextInt(6) - 3, random.nextInt(8) - 4);
            for (Direction direction : Direction.values()) {
                BlockPos adjacent = pos.relative(direction);
                BlockState adjacentState = world.getBlockState(adjacent);
                if (!adjacentState.isSolidRender((BlockGetter)world, adjacent) || !world.getBlockState(pos).canBeReplaced() || adjacentState != supportingBlockStateProvider) continue;
                world.setBlock(pos, (BlockState)blockStateProvider.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite()), 2);
                ++placed;
                continue block0;
            }
        }
        return placed > 0;
    }
}

