/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class HugeCaveMushroomFeature
extends AbstractHugeMushroomFeature {
    public HugeCaveMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    protected int getTreeHeight(RandomSource random) {
        return 7;
    }

    protected boolean isValidPosition(LevelAccessor level, BlockPos pos, int maxHeight, BlockPos.MutableBlockPos mutablePos, HugeMushroomFeatureConfiguration config) {
        int i = pos.getY();
        if (i >= level.getMinBuildHeight() + 1 && i + maxHeight + 1 < level.getMaxBuildHeight()) {
            BlockState blockstate = level.getBlockState(pos.below());
            if (!HugeCaveMushroomFeature.isDirt((BlockState)blockstate) && !blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
                return false;
            }
            for (int j = 0; j <= maxHeight; ++j) {
                int k = this.getTreeRadiusForHeight(-1, -1, config.foliageRadius, j);
                for (int l = -k; l <= k; ++l) {
                    for (int i1 = -k; i1 <= k; ++i1) {
                        BlockState blockstate1 = level.getBlockState((BlockPos)mutablePos.setWithOffset((Vec3i)pos, l, j, i1));
                        if (blockstate1.isAir() || blockstate1.is(BlockTags.LEAVES)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected void makeCap(LevelAccessor level, RandomSource random, BlockPos pos, int treeHeight, BlockPos.MutableBlockPos mutablePos, HugeMushroomFeatureConfiguration config) {
        BlockState capState = config.capProvider.getState(random, pos);
        BlockState lightState = Blocks.OCHRE_FROGLIGHT.defaultBlockState();
        int[][][] capShape = new int[][][]{new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 2, 2, 2, 1, 1}, {1, 1, 2, 2, 2, 1, 1}, {1, 1, 2, 2, 2, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 0}}, new int[][]{{0, 0, 1, 1, 1, 0, 0}, {0, 1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 0, 0}}};
        for (int y = 0; y < capShape.length; ++y) {
            for (int dx = -3; dx <= 3; ++dx) {
                for (int dz = -3; dz <= 3; ++dz) {
                    boolean isInnerThirdLayer;
                    int blockType = capShape[y][dx + 3][dz + 3];
                    if (blockType != 1 && blockType != 2) continue;
                    mutablePos.set((Vec3i)pos).move(dx, treeHeight - 1 - y, dz);
                    if (level.getBlockState((BlockPos)mutablePos).isSolidRender((BlockGetter)level, (BlockPos)mutablePos)) continue;
                    BlockState stateToPlace = blockType == 2 ? lightState : capState;
                    boolean isInnerSecondLayer = y == 1 && dx >= -2 && dx <= 2 && dz >= -2 && dz <= 2 && blockType != 2;
                    boolean bl = isInnerThirdLayer = y == 2 && dx > -3 && dx < 3 && dz > -3 && dz < 3;
                    if (stateToPlace == capState) {
                        stateToPlace = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateToPlace.setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(y != 1))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(dz != 3 && (dz != 2 || Math.abs(dx) != 2)))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(dx != -3 && (dx != -2 || Math.abs(dz) != 2)))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(dz != -3 && (dz != -2 || Math.abs(dx) != 2)))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(dx != 3 && (dx != 2 || Math.abs(dz) != 2)));
                    }
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, stateToPlace);
                }
            }
        }
    }

    protected void placeTrunk(LevelAccessor level, RandomSource random, BlockPos pos, HugeMushroomFeatureConfiguration config, int maxHeight, BlockPos.MutableBlockPos mutablePos) {
        System.out.println("Placing trunk");
        int[][][] shape = new int[][][]{new int[][]{{0, 2, 1, 2, 0}, {0, 1, 1, 1, 2}, {1, 1, 1, 1, 1}, {0, 1, 1, 1, 2}, {0, 2, 1, 2, 0}}, new int[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 1, 1, 1, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 2, 0, 0}, {0, 2, 1, 2, 0}, {0, 0, 2, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 1, 1, 1, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}}};
        for (int y = 0; y < shape.length; ++y) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    int blockType = shape[y][dx + 2][dz + 2];
                    if (blockType != 1 && (blockType != 2 || !random.nextBoolean())) continue;
                    mutablePos.set((Vec3i)pos).move(dx, y, dz);
                    BlockState stem = config.stemProvider.getState(random, pos);
                    if (level.getBlockState((BlockPos)mutablePos).isSolidRender((BlockGetter)level, (BlockPos)mutablePos)) continue;
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, (BlockState)((BlockState)stem.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(true))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
    }

    protected int getTreeRadiusForHeight(int p_65094_, int height, int foliageRadius, int y) {
        return y <= 3 ? 0 : foliageRadius;
    }
}

