/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.init;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class ModParticleTypes {
    public static void spawnParticlesToServer(Level level, double posX, double posY, double posZ, int count, double offsetX, double offsetY, double offsetZ, double speed, ParticleOptions ... particles) {
        for (ParticleOptions particle : particles) {
            if (particle == null || !(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(particle, posX, posY, posZ, count, offsetX, offsetY, offsetZ, speed);
        }
    }

    public static void spawnSquareBorderParticles(Level level, ParticleOptions particle, BlockPos pos, float radius, int particleCount, float speed) {
        if (radius < 1.0f || particleCount <= 0) {
            return;
        }
        double centerX = (double)pos.getX() + 0.5;
        double centerY = (double)pos.getY() + 0.1;
        double centerZ = (double)pos.getZ() + 0.5;
        float sideLength = radius * 2.0f + 1.0f;
        float perimeterLength = sideLength * 4.0f - 4.0f;
        float edgeLength = perimeterLength / 4.0f;
        for (int i = 0; i < particleCount; ++i) {
            double z;
            double x;
            double t = (double)i / (double)particleCount;
            double distance = t * (double)perimeterLength;
            if (distance < (double)edgeLength) {
                x = centerX - (double)radius + distance;
                z = centerZ - (double)radius;
            } else if (distance < (double)(edgeLength * 2.0f)) {
                x = centerX + (double)radius;
                z = centerZ - (double)radius + (distance - (double)edgeLength);
            } else if (distance < (double)(edgeLength * 3.0f)) {
                x = centerX + (double)radius - (distance - (double)(edgeLength * 2.0f));
                z = centerZ + (double)radius;
            } else {
                x = centerX - (double)radius;
                z = centerZ + (double)radius - (distance - (double)(edgeLength * 3.0f));
            }
            double dx = x - centerX;
            double dz = z - centerZ;
            double length = Math.sqrt(dx * dx + dz * dz);
            double motionX = dx / length * (double)speed;
            double motionZ = dz / length * (double)speed;
            level.addAlwaysVisibleParticle(particle, x, centerY, z, motionX, 0.0, motionZ);
        }
    }
}

