/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.events.tremor;

import java.util.Random;
import net.luckystudio.spelunkers_charm.events.tremor.TremorManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="spelunkers_charm", bus=EventBusSubscriber.Bus.GAME)
public class TremorEvent {
    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer minecraftServer = event.getServer();
        ServerLevel overworld = minecraftServer.getLevel(Level.OVERWORLD);
        if (overworld == null || overworld.getServer().getWorldData().isFlatWorld()) {
            return;
        }
        if (minecraftServer.getTickCount() % 6000 == 0) {
            for (ServerPlayer player : minecraftServer.getPlayerList().getPlayers()) {
                Random random = new Random();
                if (!(random.nextFloat() < 0.2f)) continue;
                float normalizedDepth = TremorEvent.getNormalizedDepth(player);
                float depthChance = 0.05f + normalizedDepth * 0.7f;
                int intensity = Mth.floor((float)(1.0f + normalizedDepth * 4.0f));
                int baseLength = Mth.floor((float)(400.0f + normalizedDepth * 400.0f));
                int length = baseLength + random.nextInt(101) - 50;
                TremorManager.spawnTremor(player.level(), player.blockPosition(), Math.max(length, 400), intensity, depthChance, false);
            }
        }
    }

    private static float getNormalizedDepth(ServerPlayer player) {
        int y = player.getBlockY();
        int minY = player.level().getMinBuildHeight();
        int maxY = 64;
        return Mth.clamp((float)((float)(maxY - y) / (float)(maxY - minY)), (float)0.0f, (float)1.0f);
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        Vec3 center = event.getExplosion().center();
        if (center.y < 32.0 && level.dimension() == Level.OVERWORLD) {
            float force = event.getExplosion().radius();
            BlockPos pos = new BlockPos((int)center.x, (int)center.y, (int)center.z);
            TremorManager.spawnTremor(level, pos, (int)(force * 60.0f), (int)force, 0.5f, false);
        }
    }
}

