/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.events.tremor;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.luckystudio.spelunkers_charm.block.custom.GeyserBlock;
import net.luckystudio.spelunkers_charm.entity.custom.rock.AbstractThrowableRock;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;

public class TremorBlockPosEvents {
    private static final Map<Block, AbstractThrowableRock.Type> ROCK_TO_DROP = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(Blocks.STONE, AbstractThrowableRock.Type.ROCK);
        map.put(Blocks.DEEPSLATE, AbstractThrowableRock.Type.DEEPSLATE_ROCK);
        map.put(Blocks.DRIPSTONE_BLOCK, AbstractThrowableRock.Type.DRIPSTONE_ROCK);
        map.put((Block)ModBlocks.WILDSTONE.get(), AbstractThrowableRock.Type.DRIPSTONE_ROCK);
        map.put(Blocks.BASALT, AbstractThrowableRock.Type.BASALT_ROCK);
        map.put((Block)ModBlocks.PERMAFROST.get(), AbstractThrowableRock.Type.ICE_BALL);
        map.put(Blocks.PACKED_ICE, AbstractThrowableRock.Type.ICE_BALL);
        map.put(Blocks.ICE, AbstractThrowableRock.Type.ICE_BALL);
    });

    public static void topEffectPos(Level level, BlockPos pos) {
        TremorBlockPosEvents.breakBlockEffectAt(level, pos);
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)block;
            level.scheduleTick(pos, (Block)fallingBlock, 1);
            return;
        }
        if (state.getBlock() instanceof PointedDripstoneBlock) {
            level.destroyBlock(pos, true);
            return;
        }
        if (state.is(BlockTags.BASE_STONE_OVERWORLD)) {
            TremorBlockPosEvents.dropRock((LevelAccessor)level, state, pos);
        }
    }

    public static void bottomEffectPos(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof GeyserBlock) {
            level.scheduleTick(pos, state.getBlock(), 1);
        }
        if (level.isClientSide()) {
            TremorBlockPosEvents.breakBlockEffectAt(level, pos);
        }
    }

    private static void breakBlockEffectAt(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Random random = new Random();
        double particleAmount = 0.5;
        if (random.nextFloat() < (float)particleAmount) {
            level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
        }
    }

    private static void dropRock(LevelAccessor levelAccessor, BlockState state, BlockPos pos) {
        AbstractThrowableRock.Type rockType = ROCK_TO_DROP.getOrDefault(state.getBlock(), AbstractThrowableRock.Type.ROCK);
        if (rockType != null) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            AbstractThrowableRock rock = AbstractThrowableRock.createRock(serverLevel, pos.getX(), pos.getY(), pos.getZ(), rockType, null);
            rock.setPos((double)pos.getX() + 0.5, (float)pos.getY() - 0.1f, (double)pos.getZ() + 0.5);
            levelAccessor.addFreshEntity((Entity)rock);
        }
    }
}

