/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.events.tremor;

import net.luckystudio.spelunkers_charm.events.tremor.TremorManager;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.level.Level;

public class Tremor
extends Marker {
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(Tremor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LENGTH = SynchedEntityData.defineId(Tremor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MAGNITUDE = SynchedEntityData.defineId(Tremor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> INTENSITY = SynchedEntityData.defineId(Tremor.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    int startUp = 0;

    public Tremor(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public int getLifetime() {
        return (Integer)this.entityData.get(LIFETIME);
    }

    public int getLength() {
        return (Integer)this.entityData.get(LENGTH);
    }

    public void setLength(int length) {
        this.entityData.set(LENGTH, (Object)Math.min(length, 1000));
    }

    public int getMagnitude() {
        return (Integer)this.entityData.get(MAGNITUDE);
    }

    public void setMagnitude(int magnitude) {
        this.entityData.set(MAGNITUDE, (Object)magnitude);
    }

    public float getIntensity() {
        return ((Float)this.entityData.get(INTENSITY)).floatValue();
    }

    public void incrementIntensity() {
        this.entityData.set(INTENSITY, (Object)Float.valueOf(this.getIntensity() + 1.0f));
    }

    public void decrementIntensity() {
        this.entityData.set(INTENSITY, (Object)Float.valueOf(this.getIntensity() - 1.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LIFETIME, (Object)0);
        builder.define(LENGTH, (Object)200);
        builder.define(MAGNITUDE, (Object)1);
        builder.define(INTENSITY, (Object)Float.valueOf(0.0f));
    }

    public void tick() {
        super.tick();
        if (this.startUp < 100) {
            ++this.startUp;
        } else {
            this.entityData.set(LIFETIME, (Object)((Integer)this.entityData.get(LIFETIME) + 1));
            if ((Integer)this.entityData.get(LIFETIME) > (Integer)this.entityData.get(LENGTH)) {
                this.remove(Entity.RemovalReason.DISCARDED);
            } else {
                TremorManager.tremorTick(this);
            }
        }
    }

    public boolean isInvisible() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean shouldRender(double x, double y, double z) {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }
}

