/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.events.custom;

import net.luckystudio.spelunkers_charm.entity.custom.minecart.BlockMinecart;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="spelunkers_charm", bus=EventBusSubscriber.Bus.GAME)
public class MinecartEvents {
    @SubscribeEvent
    public static InteractionResult onMinecartInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        Entity target = event.getTarget();
        InteractionHand hand = event.getHand();
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (!(target instanceof AbstractMinecart)) {
            return InteractionResult.PASS;
        }
        AbstractMinecart abstractMinecart = (AbstractMinecart)target;
        if (abstractMinecart instanceof MinecartTNT) {
            MinecartTNT minecartTNT = (MinecartTNT)abstractMinecart;
            minecartTNT.primeFuse();
            player.swing(hand, true);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (abstractMinecart instanceof Minecart) {
            Minecart minecart = (Minecart)abstractMinecart;
            Item item = heldItem.getItem();
            if (item instanceof BlockItem) {
                Object newMinecart;
                BlockItem blockItem = (BlockItem)item;
                if (MinecartEvents.minecartBlocks(blockItem.getBlock())) {
                    newMinecart = MinecartEvents.getAbstractMinecart(minecart, blockItem.getBlock(), level);
                    newMinecart.setPosRaw(minecart.getX(), minecart.getY(), minecart.getZ());
                    newMinecart.setDeltaMovement(minecart.getDeltaMovement());
                    newMinecart.setYRot(minecart.getYRot());
                    newMinecart.setXRot(minecart.getXRot());
                    SoundEvent placeBlockSound = blockItem.getBlock().defaultBlockState().getSoundType((LevelReader)level, BlockPos.containing((double)minecart.getX(), (double)minecart.getY(), (double)minecart.getZ()), (Entity)minecart).getPlaceSound();
                    minecart.playSound(placeBlockSound, 1.0f, 1.0f);
                    minecart.remove(Entity.RemovalReason.DISCARDED);
                    level.addFreshEntity((Entity)newMinecart);
                    player.swing(hand, true);
                    return InteractionResult.SUCCESS;
                }
                newMinecart = new BlockMinecart(level, minecart.getX(), minecart.getY(), minecart.getZ());
                newMinecart.setPosRaw(minecart.getX(), minecart.getY(), minecart.getZ());
                newMinecart.setDeltaMovement(minecart.getDeltaMovement());
                newMinecart.setYRot(minecart.getYRot());
                newMinecart.setXRot(minecart.getXRot());
                newMinecart.setDisplayBlockState(blockItem.getBlock().defaultBlockState());
                ((BlockMinecart)((Object)newMinecart)).setBlockAmount(heldItem.getCount());
                ((BlockMinecart)((Object)newMinecart)).updateName();
                heldItem.shrink(heldItem.getCount());
                SoundEvent placeBlockSound = blockItem.getBlock().defaultBlockState().getSoundType((LevelReader)level, BlockPos.containing((double)minecart.getX(), (double)minecart.getY(), (double)minecart.getZ()), (Entity)minecart).getPlaceSound();
                minecart.playSound(placeBlockSound, 1.0f, 1.0f);
                minecart.remove(Entity.RemovalReason.DISCARDED);
                level.addFreshEntity((Entity)newMinecart);
                player.swing(hand, true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean minecartBlocks(Block block) {
        return block == Blocks.HOPPER || block == Blocks.CHEST || block == Blocks.FURNACE || block == Blocks.TNT;
    }

    private static Entity getAbstractMinecart(Minecart oldMinecart, Block block, Level level) {
        if (block == Blocks.HOPPER) {
            return new MinecartHopper(level, oldMinecart.getX(), oldMinecart.getY(), oldMinecart.getZ());
        }
        if (block == Blocks.CHEST) {
            return new MinecartChest(level, oldMinecart.getX(), oldMinecart.getY(), oldMinecart.getZ());
        }
        if (block == Blocks.FURNACE) {
            return new MinecartFurnace(level, oldMinecart.getX(), oldMinecart.getY(), oldMinecart.getZ());
        }
        if (block == Blocks.TNT) {
            return new MinecartTNT(level, oldMinecart.getX(), oldMinecart.getY(), oldMinecart.getZ());
        }
        return new Minecart(level, oldMinecart.getX(), oldMinecart.getY(), oldMinecart.getZ());
    }
}

