/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.entity.util;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.common.asm.enumextension.NamedEnum;
import net.neoforged.fml.common.asm.enumextension.NetworkedEnum;
import net.neoforged.fml.common.asm.enumextension.ReservedConstructor;

@NetworkedEnum(value=NetworkedEnum.NetworkCheck.CLIENTBOUND)
@NamedEnum(value=1)
public enum WoodType implements StringRepresentable
{
    OAK(Blocks.OAK_PLANKS, "oak"),
    SPRUCE(Blocks.SPRUCE_PLANKS, "spruce"),
    BIRCH(Blocks.BIRCH_PLANKS, "birch"),
    JUNGLE(Blocks.JUNGLE_PLANKS, "jungle"),
    ACACIA(Blocks.ACACIA_PLANKS, "acacia"),
    CHERRY(Blocks.CHERRY_PLANKS, "cherry"),
    DARK_OAK(Blocks.DARK_OAK_PLANKS, "dark_oak"),
    MANGROVE(Blocks.MANGROVE_PLANKS, "mangrove"),
    BAMBOO(Blocks.BAMBOO_PLANKS, "bamboo"),
    CRIMSON(Blocks.CRIMSON_PLANKS, "crimson"),
    WARPED(Blocks.WARPED_PLANKS, "warped");

    private final String name;
    private final Supplier<Block> planksSupplier;
    final Supplier<Item> boatItem;
    public static final StringRepresentable.EnumCodec<WoodType> CODEC;
    private static final IntFunction<WoodType> BY_ID;

    @ReservedConstructor
    private WoodType(Block planks, String name) {
        this.name = name;
        this.planksSupplier = () -> planks;
        this.boatItem = () -> Items.AIR;
    }

    public String getSerializedName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Block getPlanks() {
        return this.planksSupplier.get();
    }

    public static WoodType getWoodType(ItemStack stack) {
        Item item = stack.getItem();
        for (WoodType type : WoodType.values()) {
            if (item != type.getPlanks().asItem()) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static WoodType byId(int id) {
        return BY_ID.apply(id);
    }

    public static WoodType byName(String name) {
        return (WoodType)CODEC.byName(name, (Enum)OAK);
    }

    static {
        CODEC = StringRepresentable.fromEnum(WoodType::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])WoodType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

