/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.entity.custom.rock;

import javax.annotation.Nullable;
import net.luckystudio.spelunkers_charm.entity.custom.rock.BasaltRock;
import net.luckystudio.spelunkers_charm.entity.custom.rock.DeepslateRock;
import net.luckystudio.spelunkers_charm.entity.custom.rock.DripstoneRock;
import net.luckystudio.spelunkers_charm.entity.custom.rock.IceBall;
import net.luckystudio.spelunkers_charm.entity.custom.rock.Rock;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractThrowableRock
extends ThrowableItemProjectile {
    public AbstractThrowableRock(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractThrowableRock(EntityType<? extends ThrowableItemProjectile> entityType, double x, double y, double z, Level level) {
        super(entityType, x, y, z, level);
    }

    public AbstractThrowableRock(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity shooter, Level level) {
        super(entityType, shooter, level);
    }

    public static AbstractThrowableRock createRock(ServerLevel level, double x, double y, double z, Type type, @Nullable Player player) {
        AbstractThrowableRock abstractRock = switch (type.ordinal()) {
            case 1 -> new DeepslateRock((Level)level, x, y, z);
            case 2 -> new DripstoneRock((Level)level, x, y, z);
            case 3 -> new BasaltRock((Level)level, x, y, z);
            case 4 -> new IceBall((Level)level, x, y, z);
            default -> new Rock((Level)level, x, y, z);
        };
        return abstractRock;
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        return !itemstack.isEmpty() && !itemstack.is(this.getDefaultItem()) ? new ItemParticleOption(ParticleTypes.ITEM, itemstack) : new BlockParticleOption(ParticleTypes.BLOCK, this.getCopiedBlockState());
    }

    protected abstract BlockState getCopiedBlockState();

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 3.0f);
        this.rockHit();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Level level = this.level();
        BlockState blockstate = this.level().getBlockState(result.getBlockPos());
        if (!this.level().isClientSide) {
            if (blockstate.getBlock() == Blocks.GLASS) {
                level.destroyBlock(result.getBlockPos(), false);
            } else {
                this.rockHit();
            }
        }
    }

    private void rockHit() {
        this.level().playSound((Entity)this, this.blockPosition(), this.getCopiedBlockState().getSoundType((LevelReader)this.level(), this.blockPosition(), null).getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        this.discard();
    }

    public static enum Type {
        ROCK,
        DEEPSLATE_ROCK,
        DRIPSTONE_ROCK,
        BASALT_ROCK,
        ICE_BALL;

    }
}

