/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.entity.custom.minecart;

import net.luckystudio.spelunkers_charm.init.ModEntityType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BlockMinecart
extends AbstractMinecart {
    private static final EntityDataAccessor<Integer> BLOCK_AMOUNT = SynchedEntityData.defineId(BlockMinecart.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BlockMinecart(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public BlockMinecart(Level level, double x, double y, double z) {
        super(ModEntityType.BLOCK_MINECART.get(), level, x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BLOCK_AMOUNT, (Object)0);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("BlockAmount", this.getBlockAmount());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBlockAmount(tag.getInt("BlockAmount"));
    }

    @NotNull
    protected Item getDropItem() {
        return Items.MINECART;
    }

    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    public int getBlockAmount() {
        return (Integer)this.entityData.get(BLOCK_AMOUNT);
    }

    public void setBlockAmount(int amount) {
        this.entityData.set(BLOCK_AMOUNT, (Object)amount);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (hand != InteractionHand.MAIN_HAND || this.level().isClientSide) {
            return InteractionResult.PASS;
        }
        Item item = heldItem.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (this.getDisplayBlockState().isAir() || blockItem.getBlock().defaultBlockState() == this.getDisplayBlockState()) {
                this.setDisplayBlockState(blockItem.getBlock().defaultBlockState());
                this.setBlockAmount(this.getBlockAmount() + heldItem.getCount());
                heldItem.shrink(heldItem.getCount());
                this.level().playSound((Entity)this, this.blockPosition(), blockItem.getBlock().defaultBlockState().getSoundType((LevelReader)this.level(), this.blockPosition(), (Entity)this).getPlaceSound(), player.getSoundSource(), 1.0f, 1.0f);
                this.updateName();
                return InteractionResult.SUCCESS;
            }
        } else if (this.getBlockAmount() > 0) {
            int toRemove = Math.min(64, this.getBlockAmount());
            this.setBlockAmount(this.getBlockAmount() - toRemove);
            ItemStack dropStack = new ItemStack((ItemLike)this.getDisplayBlockState().getBlock(), toRemove);
            player.addItem(dropStack);
            if (this.getBlockAmount() <= 0) {
                this.setCustomDisplay(false);
                this.setDisplayBlockState(Blocks.AIR.defaultBlockState());
                Minecart newMinecart = new Minecart(this.level(), this.getX(), this.getY(), this.getZ());
                newMinecart.setPosRaw(this.getX(), this.getY(), this.getZ());
                newMinecart.setDeltaMovement(this.getDeltaMovement());
                newMinecart.setYRot(this.getYRot());
                newMinecart.setXRot(this.getXRot());
                this.remove(Entity.RemovalReason.DISCARDED);
                this.level().addFreshEntity((Entity)newMinecart);
            }
            player.playNotifySound(SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.updateName();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void updateName() {
        if (this.getBlockAmount() > 0) {
            this.setCustomName((Component)Component.literal((String)(this.getBlockAmount() + "x")).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).applyFormat(ChatFormatting.BOLD)));
        } else {
            this.setCustomName(null);
            this.setCustomNameVisible(false);
        }
    }

    public void kill() {
        if (this.getBlockAmount() > 0 && !this.getDisplayBlockState().isAir()) {
            ItemStack dropStack = new ItemStack((ItemLike)this.getDisplayBlockState().getBlock(), this.getBlockAmount());
            this.spawnAtLocation(dropStack);
        }
        super.kill();
    }

    public void destroy(Item dropItem) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemstack = new ItemStack((ItemLike)dropItem);
            this.spawnAtLocation(itemstack);
        }
    }

    protected boolean canRide(Entity vehicle) {
        return false;
    }

    public boolean canBeRidden() {
        return false;
    }
}

