/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.entity.custom.lift;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.luckystudio.spelunkers_charm.SpelunkersCharm;
import net.luckystudio.spelunkers_charm.entity.custom.lift.AbstractLift;
import net.luckystudio.spelunkers_charm.entity.util.MineralType;
import net.luckystudio.spelunkers_charm.entity.util.WoodType;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLiftRenderer<T extends AbstractLift>
extends EntityRenderer<T> {
    private static final String PATH = "textures/entity/lift/";
    private static final Map<WoodType, String> WOOD_TYPE = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(WoodType.OAK, "oak.png");
        map.put(WoodType.SPRUCE, "spruce.png");
        map.put(WoodType.BIRCH, "birch.png");
        map.put(WoodType.JUNGLE, "jungle.png");
        map.put(WoodType.ACACIA, "acacia.png");
        map.put(WoodType.CHERRY, "cherry.png");
        map.put(WoodType.DARK_OAK, "dark_oak.png");
        map.put(WoodType.MANGROVE, "mangrove.png");
        map.put(WoodType.BAMBOO, "bamboo.png");
        map.put(WoodType.CRIMSON, "mangrove.png");
        map.put(WoodType.WARPED, "bamboo.png");
    });
    private static final Map<MineralType, String> MINERAL_TYPE = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(MineralType.IRON, "iron.png");
        map.put(MineralType.COPPER, "copper.png");
        map.put(MineralType.GOLD, "gold.png");
        map.put(MineralType.DIAMOND, "diamond.png");
        map.put(MineralType.NETHERITE, "netherite.png");
    });
    private final EntityModel<T> woodModel;
    private final EntityModel<T> mineralModel;
    private final AbstractLift.Type liftType;

    public AbstractLiftRenderer(EntityRendererProvider.Context context, EntityModel<T> model, AbstractLift.Type liftType) {
        super(context);
        this.woodModel = model;
        this.mineralModel = model;
        this.liftType = liftType;
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.translate(0.0f, -1.5f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getYRot()));
        this.handleShakeWhenHit((AbstractLift)((Object)entity), partialTick, poseStack);
        if (entity instanceof AbstractLift) {
            T abstractLift = entity;
            VertexConsumer woodVertexConsumer = bufferSource.getBuffer(this.woodModel.renderType(this.getTextureLocation((AbstractLift)((Object)abstractLift))));
            this.woodModel.setupAnim(entity, partialTick, 0.0f, 0.1f, 0.0f, 0.0f);
            this.woodModel.renderToBuffer(poseStack, woodVertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            VertexConsumer mineralVertexConsumer = bufferSource.getBuffer(this.mineralModel.renderType(this.getMineralLocation((AbstractLift)((Object)abstractLift))));
            this.mineralModel.setupAnim(entity, partialTick, 0.0f, 0.1f, 0.0f, 0.0f);
            this.mineralModel.renderToBuffer(poseStack, mineralVertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }

    private void handleShakeWhenHit(AbstractLift entity, float partialTick, PoseStack poseStack) {
        float f5 = (float)entity.getHurtTime() - partialTick;
        float f6 = entity.getDamage() - partialTick;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f5) * f5 * f6 / 10.0f * (float)entity.getHurtDir()));
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(AbstractLift entity) {
        WoodType woodType = entity.getWoodType();
        String woodTexture = WOOD_TYPE.get((Object)woodType);
        AbstractLift.Type liftType = this.liftType;
        return SpelunkersCharm.id(PATH + this.getTypeName(liftType) + woodTexture);
    }

    public ResourceLocation getMineralLocation(AbstractLift entity) {
        MineralType mineralType = entity.getMineralType();
        String mineralTexture = MINERAL_TYPE.get((Object)mineralType);
        AbstractLift.Type liftType = this.liftType;
        return SpelunkersCharm.id(PATH + this.getTypeName(liftType) + mineralTexture);
    }

    private String getTypeName(AbstractLift.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case AbstractLift.Type.SMALL -> "small/";
            case AbstractLift.Type.MEDIUM -> "medium/";
            case AbstractLift.Type.LARGE -> "large/";
        };
    }
}

