/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.luckystudio.spelunkers_charm.datagen.ModBlockLootTableProvider;
import net.luckystudio.spelunkers_charm.datagen.ModBlockStateProvider;
import net.luckystudio.spelunkers_charm.datagen.ModDataMapProvider;
import net.luckystudio.spelunkers_charm.datagen.ModDataPackProvider;
import net.luckystudio.spelunkers_charm.datagen.ModItemModelProvider;
import net.luckystudio.spelunkers_charm.datagen.ModRecipeProvider;
import net.luckystudio.spelunkers_charm.datagen.advancements.ModAdvancements;
import net.luckystudio.spelunkers_charm.datagen.biomes.biomeTags.ModBiomeTagProvider;
import net.luckystudio.spelunkers_charm.datagen.blockTags.ModBlockTagProvider;
import net.luckystudio.spelunkers_charm.datagen.itemTags.ModItemTagProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenerators {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancements(packOutput, lookupProvider, existingFileHelper));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataMapProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataPackProvider(packOutput, lookupProvider));
    }
}

