/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom.boulder;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.luckystudio.spelunkers_charm.SpelunkersCharm;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BlockStateProcessor;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderType;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderUtils;
import net.luckystudio.spelunkers_charm.block.custom.boulder.HangingType;
import net.luckystudio.spelunkers_charm.block.custom.boulder.entity.Boulder;
import net.luckystudio.spelunkers_charm.block.util.ModBlockStateProperties;
import net.luckystudio.spelunkers_charm.block.util.enums.BlockPart;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BoulderBlock
extends Block {
    public static final MapCodec<BoulderBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BoulderBlock.propertiesCodec(), (App)BoulderType.CODEC.fieldOf("type").forGetter(block -> block.type)).apply((Applicative)instance, BoulderBlock::new));
    public static final EnumProperty<HangingType> HANGING_TYPE = ModBlockStateProperties.HANGING_TYPE;
    public static final EnumProperty<BlockPart> BLOCK_PART = ModBlockStateProperties.BLOCK_PART;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty GENERATE = BooleanProperty.create((String)"generate");
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");
    public final BoulderType type;

    public BoulderBlock(BlockBehaviour.Properties properties, BoulderType type) {
        super(properties.pushReaction(PushReaction.BLOCK));
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(BLOCK_PART, (Comparable)((Object)BlockPart.TOP_MIDDLE))).setValue((Property)GENERATE, (Comparable)Boolean.valueOf(false))).setValue((Property)FULL, (Comparable)Boolean.valueOf(true))).setValue(HANGING_TYPE, (Comparable)((Object)HangingType.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, GENERATE, FULL, BLOCK_PART, HANGING_TYPE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos center;
        AABB entityBox;
        Direction clickedDirection = context.getClickedFace();
        BlockPos clickedPos = context.getClickedPos();
        Level level = context.getLevel();
        if (!level.getEntitiesOfClass(LivingEntity.class, entityBox = new AABB(Vec3.atLowerCornerOf((Vec3i)(center = clickedPos.relative(clickedDirection)).offset(-1, -1, -1)), Vec3.atLowerCornerOf((Vec3i)center.offset(2, 2, 2)))).isEmpty()) {
            return null;
        }
        BlockPos minPos = new BlockPos((int)entityBox.minX, (int)entityBox.minY, (int)entityBox.minZ);
        BlockPos maxPos = new BlockPos((int)entityBox.maxX - 1, (int)entityBox.maxY - 1, (int)entityBox.maxZ - 1);
        for (BlockPos searchPos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            if (level.getBlockState(searchPos).canBeReplaced()) continue;
            return null;
        }
        BlockState hangingState = level.getBlockState(center.above(2));
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue(HANGING_TYPE, (Comparable)((Object)this.getHangType(hangingState)))).setValue((Property)GENERATE, (Comparable)Boolean.valueOf(true))).setValue(BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_MIDDLE));
    }

    private HangingType getHangType(BlockState hangingFromState) {
        if (hangingFromState.getBlock() instanceof ChainBlock && hangingFromState.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y) {
            return HangingType.CHAINED;
        }
        return HangingType.NONE;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return super.canSurvive(state, level, pos);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        Direction offsetDirection = (Direction)state.getValue((Property)FACING);
        BlockPos offsetPos = offsetDirection == Direction.DOWN ? pos.relative(offsetDirection, 2) : pos.relative(offsetDirection).below();
        if (state.getValue(BLOCK_PART) == BlockPart.BOTTOM_MIDDLE && ((Boolean)state.getValue((Property)GENERATE)).booleanValue() && !isMoving && !oldState.is(state.getBlock())) {
            BoulderBlock.placeBoulder(level, offsetPos, this.type, (HangingType)((Object)state.getValue(HANGING_TYPE)));
        }
    }

    public static void placeBoulder(Level level, BlockPos pos, BoulderType type, HangingType hangingType) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.setBlock(pos, (BlockState)((BlockState)((BlockState)BoulderUtils.getBoulderFromType(type).setValue(BLOCK_PART, (Comparable)((Object)BlockPart.BOTTOM_MIDDLE))).setValue((Property)GENERATE, (Comparable)Boolean.valueOf(false))).setValue(HANGING_TYPE, (Comparable)((Object)hangingType)), 3);
            BlockPos boulderPos = pos.offset(-1, 0, -1);
            ResourceLocation structureId = switch (type) {
                default -> throw new MatchException(null, null);
                case BoulderType.STONE -> SpelunkersCharm.id("boulder");
                case BoulderType.IRON -> SpelunkersCharm.id("iron_boulder");
                case BoulderType.COPPER -> SpelunkersCharm.id("copper_boulder");
                case BoulderType.GOLD -> SpelunkersCharm.id("gold_boulder");
                case BoulderType.LUSH -> SpelunkersCharm.id("lush_boulder");
                case BoulderType.LUSH_IRON -> SpelunkersCharm.id("lush_iron_boulder");
                case BoulderType.LUSH_COPPER -> SpelunkersCharm.id("lush_copper_boulder");
                case BoulderType.LUSH_GOLD -> SpelunkersCharm.id("lush_gold_boulder");
            };
            StructureTemplate template = serverLevel.getStructureManager().getOrCreate(structureId);
            template.placeInWorld((ServerLevelAccessor)serverLevel, boulderPos, boulderPos, new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).setIgnoreEntities(true).addProcessor((StructureProcessor)new BlockStateProcessor(hangingType)), serverLevel.random, 3);
        }
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos bottomMiddlePos = this.getBottomMiddlePos(state, pos);
        for (BlockPos checkPos : this.boulderPositions(bottomMiddlePos)) {
            BlockState checkState = level.getBlockState(checkPos);
            if (!(checkState.getBlock() instanceof BoulderBlock)) continue;
            level.setBlock(checkPos, (BlockState)checkState.setValue((Property)FULL, (Comparable)Boolean.valueOf(false)), 3);
        }
        super.destroy(level, pos, state);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            return;
        }
        BlockPos bottomMiddlePos = this.getBottomMiddlePos(state, pos);
        BlockState blockStateHangingFrom = level.getBlockState(bottomMiddlePos.above(3));
        if (!this.isFullBoulder(state, level, pos)) {
            return;
        }
        if (!this.isSupported(level, pos)) {
            for (BlockPos checkPos : this.boulderPositions(bottomMiddlePos)) {
                BlockState checkState = level.getBlockState(checkPos);
                if (!this.isBoulderBlock(checkState)) continue;
                level.setBlock(checkPos, Blocks.AIR.defaultBlockState(), 3);
            }
            Boulder boulder = new Boulder(level, bottomMiddlePos);
            boulder.setBoulderType(this.type);
            level.addFreshEntity((Entity)boulder);
        } else {
            for (BlockPos checkPos : this.boulderPositions(bottomMiddlePos)) {
                BlockState checkState = level.getBlockState(checkPos);
                if (!this.isBoulderBlock(checkState) || !(checkState.getBlock() instanceof BoulderBlock)) continue;
                level.setBlock(checkPos, (BlockState)checkState.setValue(HANGING_TYPE, (Comparable)((Object)this.getHangType(blockStateHangingFrom))), 3);
            }
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    private BlockPos getBottomMiddlePos(BlockState state, BlockPos pos) {
        Direction facing = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPart blockPart = (BlockPart)((Object)state.getValue(BLOCK_PART));
        return switch (blockPart) {
            case BlockPart.BOTTOM_CORNER -> pos.relative(facing).relative(facing.getClockWise());
            case BlockPart.BOTTOM_SIDE -> pos.relative(facing);
            case BlockPart.MIDDLE_CORNER -> pos.relative(facing).relative(facing.getClockWise()).below();
            case BlockPart.MIDDLE_SIDE -> pos.relative(facing).below();
            case BlockPart.TOP_CORNER -> pos.relative(facing).relative(facing.getClockWise()).below(2);
            case BlockPart.TOP_SIDE -> pos.relative(facing).below(2);
            case BlockPart.TOP_MIDDLE -> pos.below(2);
            default -> pos;
        };
    }

    public boolean isBoulderBlock(BlockState state) {
        return state.is((Block)ModBlocks.BOULDER.get()) || state.is((Block)ModBlocks.IRON_BOULDER.get()) || state.is((Block)ModBlocks.COPPER_BOULDER.get()) || state.is((Block)ModBlocks.GOLD_BOULDER.get()) || state.is((Block)ModBlocks.LUSH_BOULDER.get()) || state.is((Block)ModBlocks.LUSH_IRON_BOULDER.get()) || state.is((Block)ModBlocks.LUSH_COPPER_BOULDER.get()) || state.is((Block)ModBlocks.LUSH_GOLD_BOULDER.get()) || state.is(BoulderUtils.getRawCore(this.type));
    }

    private boolean isFullBoulder(BlockState state, Level level, BlockPos pos) {
        BlockPos bottomMiddlePos = this.getBottomMiddlePos(state, pos);
        for (BlockPos checkPos : this.boulderPositions(bottomMiddlePos)) {
            if (this.isBoulderBlock(level.getBlockState(checkPos))) continue;
            return false;
        }
        return true;
    }

    private List<BlockPos> boulderPositions(BlockPos bottomMiddlePos) {
        return List.of(bottomMiddlePos, bottomMiddlePos.north(), bottomMiddlePos.north().east(), bottomMiddlePos.east(), bottomMiddlePos.south().east(), bottomMiddlePos.south(), bottomMiddlePos.south().west(), bottomMiddlePos.west(), bottomMiddlePos.north().west(), bottomMiddlePos.above(), bottomMiddlePos.above().north(), bottomMiddlePos.above().north().east(), bottomMiddlePos.above().east(), bottomMiddlePos.above().south().east(), bottomMiddlePos.above().south(), bottomMiddlePos.above().south().west(), bottomMiddlePos.above().west(), bottomMiddlePos.above().north().west(), bottomMiddlePos.above(2), bottomMiddlePos.above(2).north(), bottomMiddlePos.above(2).north().east(), bottomMiddlePos.above(2).east(), bottomMiddlePos.above(2).south().east(), bottomMiddlePos.above(2).south(), bottomMiddlePos.above(2).south().west(), bottomMiddlePos.above(2).west(), bottomMiddlePos.above(2).north().west());
    }

    private boolean isSupported(Level level, BlockPos pos) {
        BlockPos bottomMiddlePos = this.getBottomMiddlePos(level.getBlockState(pos), pos);
        return this.isSuspended(level, bottomMiddlePos) || !level.getBlockState(bottomMiddlePos.below()).canBeReplaced() || !level.getBlockState(bottomMiddlePos.below().north()).canBeReplaced() || !level.getBlockState(bottomMiddlePos.below().north().east()).canBeReplaced() || !level.getBlockState(bottomMiddlePos.below().east()).canBeReplaced() || !level.getBlockState(bottomMiddlePos.below().south().east()).canBeReplaced() || !level.getBlockState(bottomMiddlePos.below().south()).canBeReplaced() || !level.getBlockState(bottomMiddlePos.below().south().west()).canBeReplaced() || !level.getBlockState(bottomMiddlePos.below().west()).canBeReplaced() || !level.getBlockState(bottomMiddlePos.below().north().west()).canBeReplaced();
    }

    private boolean isSuspended(Level level, BlockPos bottomMiddlePos) {
        BlockState state = level.getBlockState(bottomMiddlePos.above(3));
        return state.getBlock() instanceof ChainBlock && state.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.spelunkers_charm.boulder_block").withStyle(ChatFormatting.GRAY));
    }
}

