/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom.blaster;

import java.util.List;
import net.luckystudio.spelunkers_charm.block.util.enums.GeyserType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlasterUtil {
    public static void shoot(Level level, BlockPos pos, GeyserType geyserType, Direction facing) {
        boolean isSnow;
        if (geyserType == GeyserType.NONE) {
            return;
        }
        boolean isLava = geyserType == GeyserType.LAVA;
        boolean isWater = geyserType == GeyserType.WATER;
        boolean bl = isSnow = geyserType == GeyserType.SNOW;
        if (level.getGameTime() % 5L == 0L) {
            level.playSound(null, pos.above(), SoundEvents.BLAZE_SHOOT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        SimpleParticleType mainParticle = isLava ? ParticleTypes.FLAME : (isWater ? ParticleTypes.CLOUD : ParticleTypes.SNOWFLAKE);
        SimpleParticleType secondaryParticle = isLava ? ParticleTypes.SMOKE : ParticleTypes.DRIPPING_WATER;
        Vec3 blockCenter = Vec3.atCenterOf((Vec3i)pos);
        Vec3 directionVec = Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).normalize();
        Vec3 particleOrigin = blockCenter.add(directionVec.scale(0.6));
        Vec3 particleVelocity = directionVec.scale(0.25);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 2; ++i) {
                double offsetX = 0.0;
                double offsetY = 0.0;
                double offsetZ = 0.0;
                switch (facing.getAxis()) {
                    case X: {
                        offsetY = (level.random.nextDouble() - 0.5) * 0.75;
                        offsetZ = (level.random.nextDouble() - 0.5) * 0.75;
                        break;
                    }
                    case Y: {
                        offsetX = (level.random.nextDouble() - 0.5) * 0.75;
                        offsetZ = (level.random.nextDouble() - 0.5) * 0.75;
                        break;
                    }
                    case Z: {
                        offsetX = (level.random.nextDouble() - 0.5) * 0.75;
                        offsetY = (level.random.nextDouble() - 0.5) * 0.75;
                    }
                }
                double px = particleOrigin.x + offsetX;
                double py = particleOrigin.y + offsetY;
                double pz = particleOrigin.z + offsetZ;
                serverLevel.sendParticles((ParticleOptions)mainParticle, px, py, pz, 0, particleVelocity.x, particleVelocity.y, particleVelocity.z, 1.0);
                serverLevel.sendParticles((ParticleOptions)secondaryParticle, px, py, pz, 0, particleVelocity.x, particleVelocity.y, particleVelocity.z, 1.0);
            }
        }
        DamageSource damageSource = isLava ? level.damageSources().source(DamageTypes.ON_FIRE) : (isSnow ? level.damageSources().source(DamageTypes.FREEZE) : null);
        AABB damageBox = new AABB(pos).move(directionVec).expandTowards(directionVec.scale(5.0));
        List targets = level.getEntitiesOfClass(LivingEntity.class, damageBox);
        for (LivingEntity entity : targets) {
            if (!isWater && damageSource != null) {
                entity.hurt(damageSource, 2.0f);
            }
            System.out.println("BlasterUtil: Entity hurt by geyser at " + String.valueOf(pos) + " with type " + String.valueOf((Object)geyserType));
            entity.addDeltaMovement(directionVec.scale(0.1));
            if (isLava) {
                entity.setRemainingFireTicks(40);
                continue;
            }
            if (!isSnow) continue;
            entity.setTicksFrozen(40);
        }
    }
}

