/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HangingBlock
extends Block {
    public static final MapCodec<HangingBlock> CODEC = HangingBlock.simpleCodec(HangingBlock::new);
    public static final BooleanProperty END = BooleanProperty.create((String)"end");
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public HangingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)END, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{END});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            boolean isNowBottom = !neighborState.is((Block)this);
            return (BlockState)state.setValue((Property)END, (Comparable)Boolean.valueOf(isNowBottom));
        }
        if (direction == Direction.UP && !this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockState(blockPos.above()).is((Block)this) || HangingBlock.canSupportCenter((LevelReader)levelReader, (BlockPos)blockPos.above(), (Direction)Direction.DOWN);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState belowState = level.getBlockState(pos.below());
        BlockState aboveState = level.getBlockState(pos.above());
        if (aboveState.is((Block)this)) {
            level.setBlock(pos.above(), (BlockState)aboveState.setValue((Property)END, (Comparable)Boolean.valueOf(false)), 3);
        }
        boolean isBottom = !belowState.is((Block)this);
        return (BlockState)this.defaultBlockState().setValue((Property)END, (Comparable)Boolean.valueOf(isBottom));
    }
}

