/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.mixins;

import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import com.glodblock.github.appflux.common.AFSingletons;
import com.glodblock.github.appflux.common.me.energy.EnergyTicker;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderLogic.class}, remap=false)
public abstract class MixinPatternProviderLogic
implements IUpgradeableObject {
    @Final
    @Shadow
    private PatternProviderLogicHost host;
    @Final
    @Shadow
    private IManagedGridNode mainNode;
    @Final
    @Shadow
    private IActionSource actionSource;
    @Unique
    private IUpgradeInventory af_upgrades = UpgradeInventories.empty();
    @Unique
    private EnergyTicker af_ticker;

    @Unique
    private void af_onUpgradesChanged() {
        this.host.saveChanges();
        this.host.getBlockEntity().invalidateCapabilities();
        this.af_ticker.updateSleep();
    }

    public IUpgradeInventory getUpgrades() {
        return this.af_upgrades;
    }

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")})
    private void initUpgrade(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        this.af_upgrades = UpgradeInventories.forMachine((ItemLike)host.getTerminalIcon().getItem(), (int)1, this::af_onUpgradesChanged);
        this.af_ticker = new EnergyTicker(() -> ((PatternProviderLogicHost)this.host).getBlockEntity(), this.host, () -> this.af_upgrades.isInstalled((ItemLike)AFSingletons.INDUCTION_CARD), this.mainNode, this.actionSource);
        this.mainNode.addService(IEnergyDistributor.class, (IGridNodeService)this.af_ticker);
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void saveUpgrade(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        this.af_upgrades.writeToNBT(tag, "upgrades", registries);
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void loadUpgrade(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        this.af_upgrades.readFromNBT(tag, "upgrades", registries);
    }

    @Inject(method={"addDrops"}, at={@At(value="TAIL")})
    private void dropUpgrade(List<ItemStack> drops, CallbackInfo ci) {
        for (ItemStack is : this.af_upgrades) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
    }

    @Inject(method={"clearContent"}, at={@At(value="TAIL")})
    private void clearUpgrade(CallbackInfo ci) {
        this.af_upgrades.clear();
    }
}

