/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum VoidType implements StringRepresentable
{
    ALWAYS("always"),
    SLOT_OVERFLOW("slot_overflow"),
    STORAGE_OVERFLOW("storage_overflow");

    private final String name;
    public static final Codec<VoidType> CODEC;
    public static final StreamCodec<FriendlyByteBuf, VoidType> STREAM_CODEC;
    private static final Map<String, VoidType> NAME_VALUES;
    private static final VoidType[] VALUES;

    private VoidType(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public VoidType next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static VoidType fromName(String name) {
        return NAME_VALUES.getOrDefault(name, ALWAYS);
    }

    static {
        CODEC = StringRepresentable.fromEnum(VoidType::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(VoidType.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (VoidType value : VoidType.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = VoidType.values();
    }
}

