/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FormattingCache {
    private static final Map<Integer, String> ITEM_COUNT_CACHE = new ConcurrentHashMap<Integer, String>();
    private static final Map<Integer, String> FLUID_AMOUNT_CACHE = new ConcurrentHashMap<Integer, String>();
    private static final int MAX_CACHE_SIZE = 10000;

    public static String getFormattedItemCount(int count) {
        if (ITEM_COUNT_CACHE.size() > 10000) {
            ITEM_COUNT_CACHE.clear();
        }
        return ITEM_COUNT_CACHE.computeIfAbsent(count, c -> {
            if (c >= 1000000) {
                return String.format("%.1fM", (double)c.intValue() / 1000000.0);
            }
            if (c >= 1000) {
                return String.format("%.1fK", (double)c.intValue() / 1000.0);
            }
            return String.valueOf(c);
        });
    }

    public static String getFormattedFluidAmount(int amount) {
        if (FLUID_AMOUNT_CACHE.size() > 10000) {
            FLUID_AMOUNT_CACHE.clear();
        }
        return FLUID_AMOUNT_CACHE.computeIfAbsent(amount, a -> {
            if (a >= 1000000000) {
                float mega = (float)a.intValue() / 1000000.0f;
                return String.format("%.1fM", Float.valueOf(mega));
            }
            if (a >= 1000000) {
                float kilo = (float)a.intValue() / 1000000.0f;
                return String.format("%.1fK", Float.valueOf(kilo));
            }
            if (a >= 1000) {
                float buckets = (float)a.intValue() / 1000.0f;
                if (buckets == (float)((int)buckets)) {
                    return String.format("%d", (int)buckets);
                }
                return String.format("%.1f", Float.valueOf(buckets));
            }
            return String.valueOf(a);
        });
    }

    public static void clearCaches() {
        ITEM_COUNT_CACHE.clear();
        FLUID_AMOUNT_CACHE.clear();
    }
}

