/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.screen.custom;

import com.blocklogic.realfilingreborn.network.ExtractionPacket;
import com.blocklogic.realfilingreborn.screen.custom.FluidCanisterMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class FluidCanisterScreen
extends AbstractContainerScreen<FluidCanisterMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"realfilingreborn", (String)"textures/gui/assignment_gui.png");
    private static final int EXTRACT_BUTTON_X = 154;
    private static final int EXTRACT_BUTTON_Y = 45;
    private static final int EXTRACT_BUTTON_SIZE = 12;

    public FluidCanisterScreen(FluidCanisterMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 154;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        boolean extractHover = this.isMouseOverButton(mouseX, mouseY, x + 154, y + 45, 12, 12);
        this.renderExtractButton(guiGraphics, x + 154, y + 45, extractHover);
    }

    private void renderExtractButton(GuiGraphics guiGraphics, int x, int y, boolean hover) {
        int u = hover ? 188 : 176;
        int v = 0;
        guiGraphics.blit(GUI_TEXTURE, x, y, u, v, 12, 12);
    }

    private boolean isMouseOverButton(double mouseX, double mouseY, int buttonX, int buttonY, int width, int height) {
        return mouseX >= (double)buttonX && mouseX < (double)(buttonX + width) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + height);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (this.isMouseOverButton(mouseX, mouseY, x + 154, y + 45, 12, 12)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ExtractionPacket(ExtractionPacket.ExtractionType.CANISTER), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (this.isMouseOverButton(mouseX, mouseY, x + 154, y + 45, 12, 12)) {
            MutableComponent tooltip = Component.translatable((String)"gui.realfilingreborn.extract_fluid");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        MutableComponent instruction = Component.translatable((String)"gui.realfilingreborn.canister.instruction");
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.8f, 0.8f, 1.0f);
        int textWidth = this.font.width((FormattedText)instruction);
        int scaledX = (int)(((float)this.imageWidth - (float)textWidth * 0.8f) / 2.0f / 0.8f);
        int scaledY = 25;
        guiGraphics.drawString(this.font, (Component)instruction, scaledX, scaledY, 0x2A2ADD, false);
        guiGraphics.pose().popPose();
        Component countText = ((FluidCanisterMenu)this.menu).getCurrentCountText();
        if (countText != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.8f, 0.8f, 1.0f);
            int countWidth = this.font.width((FormattedText)countText);
            int scaledCountX = (int)(((float)this.imageWidth - (float)countWidth * 0.8f) / 2.0f / 0.8f);
            int scaledCountY = 37;
            guiGraphics.drawString(this.font, countText, scaledCountX, scaledCountY, 0x404040, false);
            guiGraphics.pose().popPose();
        }
    }
}

