/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.screen.custom;

import com.blocklogic.realfilingreborn.item.custom.FluidCanisterItem;
import com.blocklogic.realfilingreborn.screen.ModMenuTypes;
import com.blocklogic.realfilingreborn.util.FluidHelper;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FluidCanisterMenu
extends AbstractContainerMenu {
    private final ItemStackHandler assignmentInventory;
    private final ItemStack canisterStack;
    private final int canisterSlot;
    private final Inventory playerInventory;

    public FluidCanisterMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, extraData.readInt());
    }

    public FluidCanisterMenu(int containerId, Inventory playerInventory, int canisterSlot) {
        super((MenuType)ModMenuTypes.FLUID_CANISTER_MENU.get(), containerId);
        this.playerInventory = playerInventory;
        this.canisterSlot = canisterSlot;
        this.canisterStack = playerInventory.getItem(canisterSlot);
        this.assignmentInventory = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                FluidCanisterMenu.this.updateCanisterAssignment();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isItemValid(int slot, ItemStack stack) {
                Item item = stack.getItem();
                if (!(item instanceof BucketItem)) return false;
                BucketItem bucketItem = (BucketItem)item;
                if (bucketItem.content == null) return false;
                if (!FluidHelper.isValidFluid(bucketItem.content)) return false;
                return true;
            }
        };
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.assignmentInventory, 0, 80, 43){

            public boolean mayPlace(ItemStack stack) {
                return FluidCanisterMenu.this.assignmentInventory.isItemValid(0, stack);
            }

            public void setChanged() {
                super.setChanged();
                FluidCanisterMenu.this.updateCanisterAssignment();
            }
        });
    }

    private void updateCanisterAssignment() {
        if (this.canisterStack.isEmpty()) {
            return;
        }
        ItemStack assignedBucket = this.assignmentInventory.getStackInSlot(0);
        if (assignedBucket.isEmpty()) {
            return;
        }
        Item item = assignedBucket.getItem();
        if (!(item instanceof BucketItem)) {
            return;
        }
        BucketItem bucketItem = (BucketItem)item;
        Fluid fluid = bucketItem.content;
        if (!FluidHelper.isValidFluid(fluid)) {
            return;
        }
        FluidCanisterItem.CanisterContents currentContents = (FluidCanisterItem.CanisterContents)this.canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value());
        if (currentContents == null || currentContents.storedFluidId().isEmpty()) {
            ResourceLocation fluidId = FluidHelper.getStillFluid(FluidHelper.getFluidId(fluid));
            FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(Optional.of(fluidId), 1000);
            this.canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
            this.assignmentInventory.setStackInSlot(0, new ItemStack((ItemLike)Items.BUCKET));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 36) {
                if (!this.moveItemStackTo(itemstack1, 0, 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.assignmentInventory.isItemValid(0, itemstack1)) {
                if (!this.moveItemStackTo(itemstack1, 36, 37, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public Component getCurrentCountText() {
        if (this.canisterStack.isEmpty()) {
            return null;
        }
        FluidCanisterItem.CanisterContents contents = (FluidCanisterItem.CanisterContents)this.canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value());
        if (contents != null && contents.storedFluidId().isPresent()) {
            int buckets = contents.amount() / 1000;
            int millibuckets = contents.amount() % 1000;
            String amountText = buckets > 0 ? (millibuckets > 0 ? buckets + "." + millibuckets / 100 + "B" : buckets + "B") : millibuckets + "mB";
            return Component.translatable((String)"gui.realfilingreborn.current_fluid_amount", (Object[])new Object[]{amountText});
        }
        return null;
    }

    public void extractFluid() {
        if (this.canisterStack.isEmpty()) {
            return;
        }
        FluidCanisterItem.CanisterContents contents = (FluidCanisterItem.CanisterContents)this.canisterStack.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value());
        if (contents == null || contents.storedFluidId().isEmpty() || contents.amount() < 1000) {
            return;
        }
        Player player = this.playerInventory.player;
        boolean hasEmptyBucket = false;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != Items.BUCKET) continue;
            hasEmptyBucket = true;
            break;
        }
        if (!hasEmptyBucket) {
            return;
        }
        ResourceLocation fluidId = contents.storedFluidId().get();
        ItemStack bucketToGive = FluidHelper.getBucketForFluid(fluidId);
        if (bucketToGive.isEmpty()) {
            return;
        }
        boolean bucketRemoved = false;
        for (int i = 0; i < player.getInventory().getContainerSize() && !bucketRemoved; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != Items.BUCKET) continue;
            stack.shrink(1);
            bucketRemoved = true;
        }
        if (!bucketRemoved) {
            return;
        }
        int newAmount = contents.amount() - 1000;
        FluidCanisterItem.CanisterContents newContents = new FluidCanisterItem.CanisterContents(contents.storedFluidId(), Math.max(0, newAmount));
        this.canisterStack.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)newContents);
        if (!player.getInventory().add(bucketToGive)) {
            player.drop(bucketToGive, false);
        }
        this.broadcastChanges();
    }

    public boolean stillValid(Player player) {
        return !this.canisterStack.isEmpty() && this.canisterStack.getItem() instanceof FluidCanisterItem;
    }

    public void removed(Player player) {
        super.removed(player);
        if (!this.assignmentInventory.getStackInSlot(0).isEmpty()) {
            player.drop(this.assignmentInventory.getStackInSlot(0), false);
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 70 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 128));
        }
    }
}

