/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.screen.custom;

import com.blocklogic.realfilingreborn.config.Config;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import com.blocklogic.realfilingreborn.screen.ModMenuTypes;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FilingFolderMenu
extends AbstractContainerMenu {
    private final ItemStackHandler assignmentInventory;
    private final ItemStack folderStack;
    private final int folderSlot;
    private final Inventory playerInventory;
    private final boolean isNBTFolder;

    public FilingFolderMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, extraData.readInt());
    }

    public FilingFolderMenu(int containerId, Inventory playerInventory, int folderSlot) {
        super((MenuType)ModMenuTypes.FILING_FOLDER_MENU.get(), containerId);
        this.playerInventory = playerInventory;
        this.folderSlot = folderSlot;
        this.folderStack = playerInventory.getItem(folderSlot);
        this.isNBTFolder = this.folderStack.getItem() instanceof NBTFilingFolderItem;
        this.assignmentInventory = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                FilingFolderMenu.this.updateFolderAssignment();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (FilingFolderMenu.this.isNBTFolder) {
                    return NBTFilingFolderItem.hasSignificantNBT(stack);
                }
                return !FilingFolderItem.hasSignificantNBT(stack);
            }
        };
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.assignmentInventory, 0, 80, 43){

            public boolean mayPlace(ItemStack stack) {
                return FilingFolderMenu.this.assignmentInventory.isItemValid(0, stack);
            }

            public void setChanged() {
                super.setChanged();
                FilingFolderMenu.this.updateFolderAssignment();
            }
        });
    }

    private void updateFolderAssignment() {
        if (this.folderStack.isEmpty()) {
            return;
        }
        ItemStack assignedItem = this.assignmentInventory.getStackInSlot(0);
        if (assignedItem.isEmpty()) {
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)assignedItem.getItem());
        if (this.isNBTFolder) {
            NBTFilingFolderItem.NBTFolderContents currentContents = (NBTFilingFolderItem.NBTFolderContents)this.folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
            if (currentContents == null || currentContents.storedItemId().isEmpty()) {
                ArrayList<NBTFilingFolderItem.SerializedItemStack> items = new ArrayList<NBTFilingFolderItem.SerializedItemStack>();
                ItemStack singleItem = assignedItem.copy();
                singleItem.setCount(1);
                items.add(new NBTFilingFolderItem.SerializedItemStack(singleItem));
                NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(Optional.of(itemId), items);
                this.folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                this.assignmentInventory.setStackInSlot(0, ItemStack.EMPTY);
            }
        } else {
            FilingFolderItem.FolderContents currentContents = (FilingFolderItem.FolderContents)this.folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
            if (currentContents == null || currentContents.storedItemId().isEmpty()) {
                FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(Optional.of(itemId), assignedItem.getCount());
                this.folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                this.assignmentInventory.setStackInSlot(0, ItemStack.EMPTY);
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 36) {
                if (!this.moveItemStackTo(itemstack1, 0, 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.assignmentInventory.isItemValid(0, itemstack1)) {
                if (!this.moveItemStackTo(itemstack1, 36, 37, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public Component getCurrentCountText() {
        if (this.folderStack.isEmpty()) {
            return null;
        }
        if (this.isNBTFolder) {
            NBTFilingFolderItem.NBTFolderContents contents = (NBTFilingFolderItem.NBTFolderContents)this.folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
            if (contents != null && contents.storedItemId().isPresent()) {
                int count = contents.storedItems().size();
                return Component.translatable((String)"gui.realfilingreborn.current_nbt_count", (Object[])new Object[]{count, Config.getMaxNBTFolderStorage()});
            }
        } else {
            FilingFolderItem.FolderContents contents = (FilingFolderItem.FolderContents)this.folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
            if (contents != null && contents.storedItemId().isPresent()) {
                return Component.translatable((String)"gui.realfilingreborn.current_item_count", (Object[])new Object[]{String.format("%,d", contents.count())});
            }
        }
        return null;
    }

    public void extractItems() {
        if (this.folderStack.isEmpty()) {
            return;
        }
        if (this.isNBTFolder) {
            this.extractFromNBTFolder();
        } else {
            this.extractFromRegularFolder();
        }
    }

    private void extractFromRegularFolder() {
        FilingFolderItem.FolderContents contents = (FilingFolderItem.FolderContents)this.folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
        if (contents == null || contents.storedItemId().isEmpty() || contents.count() <= 0) {
            return;
        }
        ResourceLocation itemId = contents.storedItemId().get();
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        ItemStack dummyStack = new ItemStack((ItemLike)item);
        int maxStackSize = item.getMaxStackSize(dummyStack);
        int extractAmount = Math.min(contents.count(), maxStackSize);
        if (extractAmount <= 0) {
            return;
        }
        ItemStack extractedStack = new ItemStack((ItemLike)item, extractAmount);
        Player player = this.playerInventory.player;
        if (player.getInventory().add(extractedStack)) {
            int newCount = contents.count() - extractAmount;
            FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(contents.storedItemId(), Math.max(0, newCount));
            this.folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
        } else {
            player.drop(extractedStack, false);
            int newCount = contents.count() - extractAmount;
            FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(contents.storedItemId(), Math.max(0, newCount));
            this.folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
        }
        this.broadcastChanges();
    }

    private void extractFromNBTFolder() {
        NBTFilingFolderItem.NBTFolderContents contents = (NBTFilingFolderItem.NBTFolderContents)this.folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
        if (contents == null || contents.storedItemId().isEmpty() || contents.storedItems().isEmpty()) {
            return;
        }
        ArrayList<NBTFilingFolderItem.SerializedItemStack> items = new ArrayList<NBTFilingFolderItem.SerializedItemStack>(contents.storedItems());
        NBTFilingFolderItem.SerializedItemStack serializedItem = (NBTFilingFolderItem.SerializedItemStack)items.remove(items.size() - 1);
        ItemStack extracted = serializedItem.stack().copy();
        Player player = this.playerInventory.player;
        if (player.getInventory().add(extracted)) {
            NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(contents.storedItemId(), items);
            this.folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
        } else {
            player.drop(extracted, false);
            NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(contents.storedItemId(), items);
            this.folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
        }
    }

    public boolean stillValid(Player player) {
        return !this.folderStack.isEmpty() && (this.folderStack.getItem() instanceof FilingFolderItem || this.folderStack.getItem() instanceof NBTFilingFolderItem);
    }

    public void removed(Player player) {
        super.removed(player);
        if (!this.assignmentInventory.getStackInSlot(0).isEmpty()) {
            player.drop(this.assignmentInventory.getStackInSlot(0), false);
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 70 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 128));
        }
    }

    public boolean isNBTFolder() {
        return this.isNBTFolder;
    }
}

