/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.network;

import com.blocklogic.realfilingreborn.screen.custom.FilingFolderMenu;
import com.blocklogic.realfilingreborn.screen.custom.FluidCanisterMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ExtractionPacket(ExtractionType extractionType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ExtractionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"realfilingreborn", (String)"extraction"));
    public static final StreamCodec<FriendlyByteBuf, ExtractionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of(FriendlyByteBuf::writeVarInt, FriendlyByteBuf::readVarInt), ExtractionPacket::typeOrdinal, ExtractionPacket::fromOrdinal);

    public int typeOrdinal() {
        return this.extractionType.ordinal();
    }

    public static ExtractionPacket fromOrdinal(int ordinal) {
        return new ExtractionPacket(ExtractionType.values()[ordinal]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ExtractionPacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            AbstractContainerMenu abstractContainerMenu;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (packet.extractionType == ExtractionType.FOLDER && (abstractContainerMenu = serverPlayer.containerMenu) instanceof FilingFolderMenu) {
                FilingFolderMenu menu = (FilingFolderMenu)abstractContainerMenu;
                menu.extractItems();
            } else if (packet.extractionType == ExtractionType.CANISTER && (abstractContainerMenu = serverPlayer.containerMenu) instanceof FluidCanisterMenu) {
                FluidCanisterMenu menu = (FluidCanisterMenu)abstractContainerMenu;
                menu.extractFluid();
            }
        }
    }

    public static enum ExtractionType {
        FOLDER,
        CANISTER;

    }
}

