/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.item.custom;

import com.blocklogic.realfilingreborn.config.Config;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.screen.custom.FilingFolderMenu;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NBTFilingFolderItem
extends Item {
    private static final Codec<SerializedItemStack> SERIALIZED_STACK_CODEC = ItemStack.CODEC.xmap(SerializedItemStack::new, SerializedItemStack::stack);
    private static final StreamCodec<RegistryFriendlyByteBuf, SerializedItemStack> SERIALIZED_STACK_STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, SerializedItemStack::stack, SerializedItemStack::new);
    private static final Codec<NBTFolderContents> NBT_FOLDER_CONTENTS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("storedItemId").forGetter(NBTFolderContents::storedItemId), (App)Codec.list(SERIALIZED_STACK_CODEC).fieldOf("storedItems").forGetter(NBTFolderContents::storedItems)).apply((Applicative)instance, NBTFolderContents::new));
    public static final StreamCodec<ByteBuf, ResourceLocation> RESOURCE_LOCATION_STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ResourceLocation::parse, ResourceLocation::toString);
    private static final StreamCodec<RegistryFriendlyByteBuf, NBTFolderContents> NBT_FOLDER_CONTENTS_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(RESOURCE_LOCATION_STREAM_CODEC), NBTFolderContents::storedItemId, (StreamCodec)SERIALIZED_STACK_STREAM_CODEC.apply(ByteBufCodecs.list((int)256)), NBTFolderContents::storedItems, NBTFolderContents::new);
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"realfilingreborn");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<NBTFolderContents>> NBT_FOLDER_CONTENTS = DATA_COMPONENTS.register("nbt_folder_contents", () -> DataComponentType.builder().persistent(NBT_FOLDER_CONTENTS_CODEC).networkSynchronized(NBT_FOLDER_CONTENTS_STREAM_CODEC).build());

    public NBTFilingFolderItem(Item.Properties properties) {
        super(properties.component((DataComponentType)NBT_FOLDER_CONTENTS.value(), (Object)new NBTFolderContents(Optional.empty(), new ArrayList<SerializedItemStack>())));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack folderStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)folderStack);
        }
        if (player.isShiftKeyDown()) {
            if (player instanceof ServerPlayer) {
                int finalSlotIndex;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int foundSlotIndex = -1;
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    if (player.getInventory().getItem(i) != folderStack) continue;
                    foundSlotIndex = i;
                    break;
                }
                if ((finalSlotIndex = foundSlotIndex) != -1) {
                    MutableComponent title = Component.translatable((String)"gui.realfilingreborn.nbt_folder.title");
                    serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, playerEntity) -> new FilingFolderMenu(containerId, inventory, finalSlotIndex), (Component)title), buf -> buf.writeInt(finalSlotIndex));
                    return InteractionResultHolder.success((Object)folderStack);
                }
            }
            return InteractionResultHolder.success((Object)folderStack);
        }
        ItemStack itemToStore = player.getItemInHand(InteractionHand.OFF_HAND);
        if (itemToStore.isEmpty() || itemToStore.getItem() instanceof FilingFolderItem || itemToStore.getItem() instanceof NBTFilingFolderItem) {
            if (itemToStore.getItem() instanceof FilingFolderItem || itemToStore.getItem() instanceof NBTFilingFolderItem) {
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.no_folder_ception"), true);
                return InteractionResultHolder.pass((Object)folderStack);
            }
            return InteractionResultHolder.pass((Object)folderStack);
        }
        if (!NBTFilingFolderItem.hasSignificantNBT(itemToStore)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.nbt_folder_requires_nbt"), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        if (!player.isShiftKeyDown() && folderStack.getCount() > 1) {
            ItemStack singleFolder = folderStack.copy();
            singleFolder.setCount(1);
            NBTFolderContents contents = (NBTFolderContents)singleFolder.get((DataComponentType)NBT_FOLDER_CONTENTS.value());
            if (contents == null) {
                contents = new NBTFolderContents(Optional.empty(), new ArrayList<SerializedItemStack>());
                singleFolder.set((DataComponentType)NBT_FOLDER_CONTENTS.value(), (Object)contents);
            }
            InteractionResultHolder<ItemStack> result = this.storeItem(level, player, singleFolder, itemToStore, contents);
            ItemStack modifiedFolder = (ItemStack)result.getObject();
            folderStack.shrink(1);
            if (!player.getInventory().add(modifiedFolder)) {
                player.drop(modifiedFolder, false);
            }
            return InteractionResultHolder.success((Object)folderStack);
        }
        NBTFolderContents contents = (NBTFolderContents)folderStack.get((DataComponentType)NBT_FOLDER_CONTENTS.value());
        if (contents == null) {
            contents = new NBTFolderContents(Optional.empty(), new ArrayList<SerializedItemStack>());
            folderStack.set((DataComponentType)NBT_FOLDER_CONTENTS.value(), (Object)contents);
        }
        return this.storeItem(level, player, folderStack, itemToStore, contents);
    }

    public static boolean hasSignificantNBT(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.isDamaged()) {
            return true;
        }
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null && !enchantments.isEmpty()) {
            return true;
        }
        ItemEnchantments stored = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
        if (stored != null && !stored.isEmpty()) {
            return true;
        }
        if (stack.get(DataComponents.CUSTOM_NAME) != null) {
            return true;
        }
        ItemLore lore = (ItemLore)stack.get(DataComponents.LORE);
        if (lore != null && !lore.lines().isEmpty()) {
            return true;
        }
        PotionContents potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        return potion != null && (!potion.customEffects().isEmpty() || !potion.potion().isEmpty());
    }

    private InteractionResultHolder<ItemStack> extractItem(Level level, Player player, ItemStack folderStack, NBTFolderContents contents) {
        if (contents == null || contents.storedItemId().isEmpty() || contents.storedItems().isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_empty"), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        ArrayList<SerializedItemStack> items = new ArrayList<SerializedItemStack>(contents.storedItems());
        SerializedItemStack serializedItem = (SerializedItemStack)items.remove(items.size() - 1);
        ItemStack extracted = serializedItem.stack().copy();
        NBTFolderContents newContents = new NBTFolderContents(contents.storedItemId(), items);
        folderStack.set((DataComponentType)NBT_FOLDER_CONTENTS.value(), (Object)newContents);
        if (player.getInventory().add(extracted)) {
            return InteractionResultHolder.success((Object)folderStack);
        }
        player.drop(extracted, false);
        return InteractionResultHolder.success((Object)folderStack);
    }

    private InteractionResultHolder<ItemStack> storeItem(Level level, Player player, ItemStack folderStack, ItemStack itemToStore, NBTFolderContents contents) {
        ArrayList currentItems;
        if (itemToStore.isEmpty() || !NBTFilingFolderItem.hasSignificantNBT(itemToStore)) {
            return InteractionResultHolder.pass((Object)folderStack);
        }
        ResourceLocation newItemId = BuiltInRegistries.ITEM.getKey((Object)itemToStore.getItem());
        Optional<ResourceLocation> currentItemIdOpt = contents.storedItemId();
        if (currentItemIdOpt.isPresent() && !currentItemIdOpt.get().equals((Object)newItemId)) {
            Item storedItem = (Item)BuiltInRegistries.ITEM.get(currentItemIdOpt.get());
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.wrong_item_type", (Object[])new Object[]{storedItem.getDescription().copy().withStyle(ChatFormatting.YELLOW)}), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        ArrayList arrayList = currentItems = contents.storedItems() != null ? contents.storedItems() : new ArrayList();
        if (currentItems.size() >= Config.getMaxNBTFolderStorage()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.nbt_folder_full"), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        ArrayList<SerializedItemStack> newItems = new ArrayList<SerializedItemStack>(currentItems);
        ItemStack itemCopy = itemToStore.copy();
        itemCopy.setCount(1);
        newItems.add(new SerializedItemStack(itemCopy));
        NBTFolderContents newContents = new NBTFolderContents(Optional.of(newItemId), newItems);
        folderStack.set((DataComponentType)NBT_FOLDER_CONTENTS.value(), (Object)newContents);
        itemToStore.shrink(1);
        return InteractionResultHolder.success((Object)folderStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        NBTFolderContents contents = (NBTFolderContents)stack.get((DataComponentType)NBT_FOLDER_CONTENTS.value());
        if (contents != null && contents.storedItemId().isPresent()) {
            ResourceLocation itemId = contents.storedItemId().get();
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.stored_item", (Object[])new Object[]{Component.literal((String)item.getDescription().getString()).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
            if (contents.storedItems() != null && !contents.storedItems().isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.nbt_item_count", (Object[])new Object[]{Component.literal((String)String.valueOf(contents.storedItems().size())).withStyle(ChatFormatting.GREEN), Component.literal((String)String.valueOf(Config.getMaxNBTFolderStorage())).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.GRAY));
                if (flag.isAdvanced() && !contents.storedItems().isEmpty()) {
                    tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.nbt_items_stored").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    int maxToShow = Math.min(3, contents.storedItems().size());
                    for (int i = 0; i < maxToShow; ++i) {
                        ItemStack storedItem = contents.storedItems().get(i).stack();
                        Component itemName = storedItem.getDisplayName();
                        tooltip.add((Component)Component.literal((String)" - ").append(itemName).withStyle(ChatFormatting.DARK_GRAY));
                    }
                    if (contents.storedItems().size() > maxToShow) {
                        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.and_x_more", (Object[])new Object[]{contents.storedItems().size() - maxToShow}).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                    }
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.empty_folder").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.nbt_unregistered_folder").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.nbt_standard_folder_info").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.folder_gui_hint").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public record NBTFolderContents(Optional<ResourceLocation> storedItemId, List<SerializedItemStack> storedItems) {
    }

    public record SerializedItemStack(ItemStack stack) {
    }
}

