/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.item.custom;

import com.blocklogic.realfilingreborn.block.custom.FilingCabinetBlock;
import com.blocklogic.realfilingreborn.block.custom.FilingIndexBlock;
import com.blocklogic.realfilingreborn.block.custom.FluidCabinetBlock;
import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.FilingIndexBlockEntity;
import com.blocklogic.realfilingreborn.block.entity.FluidCabinetBlockEntity;
import com.blocklogic.realfilingreborn.component.LedgerData;
import com.blocklogic.realfilingreborn.component.ModDataComponents;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LedgerItem
extends Item {
    private static final int MAX_SELECTION_SIZE = 1000;
    private static final int MAX_SELECTION_DIMENSION = 32;

    public LedgerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.toggleOperationMode(stack, player);
        } else {
            this.toggleSelectionMode(stack, player);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        if (player == null) {
            return InteractionResult.FAIL;
        }
        LedgerData data = (LedgerData)stack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        if (state.getBlock() instanceof FilingIndexBlock && player.isShiftKeyDown()) {
            this.selectController(stack, pos, player);
            return InteractionResult.SUCCESS;
        }
        if ((state.getBlock() instanceof FilingCabinetBlock || state.getBlock() instanceof FluidCabinetBlock) && player.isShiftKeyDown()) {
            if (data.selectionMode() == LedgerData.SelectionMode.SINGLE) {
                this.handleSingleCabinetAction(level, pos, stack, player);
            } else {
                this.handleMultiCabinetAction(level, pos, stack, player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void toggleOperationMode(ItemStack stack, Player player) {
        LedgerData currentData = (LedgerData)stack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        LedgerData.OperationMode newMode = currentData.operationMode() == LedgerData.OperationMode.ADD ? LedgerData.OperationMode.REMOVE : LedgerData.OperationMode.ADD;
        LedgerData newData = currentData.withOperationMode(newMode);
        stack.set((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)newData);
        MutableComponent message = newMode == LedgerData.OperationMode.ADD ? Component.translatable((String)"item.realfilingreborn.ledger.mode.add") : Component.translatable((String)"item.realfilingreborn.ledger.mode.remove");
        player.displayClientMessage((Component)message, true);
    }

    private void toggleSelectionMode(ItemStack stack, Player player) {
        LedgerData currentData = (LedgerData)stack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        LedgerData.SelectionMode newMode = currentData.selectionMode() == LedgerData.SelectionMode.SINGLE ? LedgerData.SelectionMode.MULTI : LedgerData.SelectionMode.SINGLE;
        LedgerData newData = currentData.withSelectionMode(newMode);
        stack.set((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)newData);
        MutableComponent message = newMode == LedgerData.SelectionMode.SINGLE ? Component.translatable((String)"item.realfilingreborn.ledger.selection.single") : Component.translatable((String)"item.realfilingreborn.ledger.selection.multi");
        player.displayClientMessage((Component)message, true);
    }

    private void selectController(ItemStack stack, BlockPos controllerPos, Player player) {
        LedgerData currentData = (LedgerData)stack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        LedgerData newData = currentData.withSelectedController(controllerPos);
        stack.set((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)newData);
        MutableComponent message = Component.translatable((String)"item.realfilingreborn.ledger.controller.selected", (Object[])new Object[]{controllerPos.getX(), controllerPos.getY(), controllerPos.getZ()});
        player.displayClientMessage((Component)message, true);
    }

    private void handleSingleCabinetAction(Level level, BlockPos cabinetPos, ItemStack stack, Player player) {
        MutableComponent message;
        LedgerData data = (LedgerData)stack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        if (data.selectedController() == null) {
            MutableComponent message2 = Component.translatable((String)"item.realfilingreborn.ledger.error.no_controller");
            player.displayClientMessage((Component)message2, true);
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(data.selectedController());
        if (!(blockEntity instanceof FilingIndexBlockEntity)) {
            message = Component.translatable((String)"item.realfilingreborn.ledger.error.no_controller");
            player.displayClientMessage((Component)message, true);
            return;
        }
        FilingIndexBlockEntity indexEntity = (FilingIndexBlockEntity)blockEntity;
        if (!this.isInRange(data.selectedController(), cabinetPos, indexEntity.getRange())) {
            message = Component.translatable((String)"item.realfilingreborn.ledger.cabinet.out_of_range");
            player.displayClientMessage((Component)message, true);
            return;
        }
        BlockEntity blockEntity2 = level.getBlockEntity(cabinetPos);
        if (blockEntity2 instanceof FilingCabinetBlockEntity) {
            FilingCabinetBlockEntity cabinetEntity = (FilingCabinetBlockEntity)blockEntity2;
            if (data.operationMode() == LedgerData.OperationMode.ADD) {
                cabinetEntity.setControllerPos(data.selectedController());
                indexEntity.addCabinet(cabinetPos);
                message = Component.translatable((String)"item.realfilingreborn.ledger.cabinet.linked");
                player.displayClientMessage((Component)message, true);
            } else {
                BlockEntity blockEntity3;
                oldControllerPos = cabinetEntity.getControllerPos();
                cabinetEntity.clearControllerPos();
                if (oldControllerPos != null && (blockEntity3 = level.getBlockEntity((BlockPos)oldControllerPos)) instanceof FilingIndexBlockEntity) {
                    FilingIndexBlockEntity oldIndex = (FilingIndexBlockEntity)blockEntity3;
                    oldIndex.removeCabinet(cabinetPos);
                }
                MutableComponent message3 = Component.translatable((String)"item.realfilingreborn.ledger.cabinet.unlinked");
                player.displayClientMessage((Component)message3, true);
            }
        } else {
            oldControllerPos = level.getBlockEntity(cabinetPos);
            if (oldControllerPos instanceof FluidCabinetBlockEntity) {
                FluidCabinetBlockEntity fluidCabinetEntity = (FluidCabinetBlockEntity)oldControllerPos;
                if (data.operationMode() == LedgerData.OperationMode.ADD) {
                    fluidCabinetEntity.setControllerPos(data.selectedController());
                    indexEntity.addCabinet(cabinetPos);
                    message = Component.translatable((String)"item.realfilingreborn.ledger.cabinet.linked");
                    player.displayClientMessage((Component)message, true);
                } else {
                    BlockEntity blockEntity4;
                    oldControllerPos = fluidCabinetEntity.getControllerPos();
                    fluidCabinetEntity.clearControllerPos();
                    if (oldControllerPos != null && (blockEntity4 = level.getBlockEntity((BlockPos)oldControllerPos)) instanceof FilingIndexBlockEntity) {
                        FilingIndexBlockEntity oldIndex = (FilingIndexBlockEntity)blockEntity4;
                        oldIndex.removeCabinet(cabinetPos);
                    }
                    MutableComponent message4 = Component.translatable((String)"item.realfilingreborn.ledger.cabinet.unlinked");
                    player.displayClientMessage((Component)message4, true);
                }
            }
        }
    }

    private void handleMultiCabinetAction(Level level, BlockPos cabinetPos, ItemStack stack, Player player) {
        LedgerData data = (LedgerData)stack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        if (data.firstMultiPos() == null) {
            LedgerData newData = data.withFirstMultiPos(cabinetPos);
            stack.set((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)newData);
            MutableComponent message = Component.translatable((String)"item.realfilingreborn.ledger.multi.start", (Object[])new Object[]{cabinetPos.getX(), cabinetPos.getY(), cabinetPos.getZ()});
            player.displayClientMessage((Component)message, true);
        } else {
            this.processMultiSelection(level, data.firstMultiPos(), cabinetPos, stack, player);
            LedgerData newData = data.withFirstMultiPos(null);
            stack.set((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)newData);
        }
    }

    private void processMultiSelection(Level level, BlockPos pos1, BlockPos pos2, ItemStack stack, Player player) {
        BlockEntity blockEntity;
        LedgerData data = (LedgerData)stack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        if (data.selectedController() == null && data.operationMode() == LedgerData.OperationMode.ADD) {
            MutableComponent message = Component.translatable((String)"item.realfilingreborn.ledger.error.no_controller");
            player.displayClientMessage((Component)message, true);
            return;
        }
        int minX = Math.min(pos1.getX(), pos2.getX());
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int maxY = Math.max(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        int sizeX = maxX - minX + 1;
        int sizeY = maxY - minY + 1;
        int sizeZ = maxZ - minZ + 1;
        if (sizeX > 32 || sizeY > 32 || sizeZ > 32) {
            player.displayClientMessage((Component)Component.literal((String)"Selection too large! Maximum size: 32 blocks per dimension").withStyle(ChatFormatting.RED), true);
            return;
        }
        long totalBlocks = (long)sizeX * (long)sizeY * (long)sizeZ;
        if (totalBlocks > 1000L) {
            player.displayClientMessage((Component)Component.literal((String)"Selection too large! Maximum total blocks: 1000").withStyle(ChatFormatting.RED), true);
            return;
        }
        FilingIndexBlockEntity indexEntity = null;
        if (data.selectedController() != null && (blockEntity = level.getBlockEntity(data.selectedController())) instanceof FilingIndexBlockEntity) {
            FilingIndexBlockEntity index;
            indexEntity = index = (FilingIndexBlockEntity)blockEntity;
        }
        HashMap<BlockPos, FilingIndexBlockEntity> controllerLookup = new HashMap<BlockPos, FilingIndexBlockEntity>();
        if (data.operationMode() == LedgerData.OperationMode.REMOVE) {
            int searchRadius = Math.min(64, Math.max(sizeX, Math.max(sizeY, sizeZ)) * 2);
            BlockPos center = new BlockPos((minX + maxX) / 2, (minY + maxY) / 2, (minZ + maxZ) / 2);
            for (int dx = -searchRadius; dx <= searchRadius; dx += 8) {
                for (int dy = -searchRadius; dy <= searchRadius; dy += 8) {
                    for (int dz = -searchRadius; dz <= searchRadius; dz += 8) {
                        BlockPos checkPos = center.offset(dx, dy, dz);
                        BlockEntity blockEntity2 = level.getBlockEntity(checkPos);
                        if (!(blockEntity2 instanceof FilingIndexBlockEntity)) continue;
                        FilingIndexBlockEntity controller = (FilingIndexBlockEntity)blockEntity2;
                        controllerLookup.put(checkPos, controller);
                    }
                }
            }
        }
        HashSet<BlockPos> cabinetsToAdd = new HashSet<BlockPos>();
        HashSet<BlockPos> cabinetsToRemove = new HashSet<BlockPos>();
        int processedCount = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockState state = level.getBlockState(currentPos);
                    if (!(state.getBlock() instanceof FilingCabinetBlock) && !(state.getBlock() instanceof FluidCabinetBlock) || data.operationMode() == LedgerData.OperationMode.ADD && indexEntity != null && !this.isInRange(data.selectedController(), currentPos, indexEntity.getRange())) continue;
                    boolean processed = false;
                    BlockEntity blockEntity3 = level.getBlockEntity(currentPos);
                    if (blockEntity3 instanceof FilingCabinetBlockEntity) {
                        FilingCabinetBlockEntity cabinetEntity = (FilingCabinetBlockEntity)blockEntity3;
                        if (data.operationMode() == LedgerData.OperationMode.ADD) {
                            cabinetEntity.setControllerPos(data.selectedController());
                            cabinetsToAdd.add(currentPos);
                        } else {
                            oldControllerPos = cabinetEntity.getControllerPos();
                            cabinetEntity.clearControllerPos();
                            if (oldControllerPos != null && controllerLookup.containsKey(oldControllerPos)) {
                                cabinetsToRemove.add(currentPos);
                            }
                        }
                        processed = true;
                    } else {
                        oldControllerPos = level.getBlockEntity(currentPos);
                        if (oldControllerPos instanceof FluidCabinetBlockEntity) {
                            FluidCabinetBlockEntity fluidCabinetEntity = (FluidCabinetBlockEntity)oldControllerPos;
                            if (data.operationMode() == LedgerData.OperationMode.ADD) {
                                fluidCabinetEntity.setControllerPos(data.selectedController());
                                cabinetsToAdd.add(currentPos);
                            } else {
                                oldControllerPos = fluidCabinetEntity.getControllerPos();
                                fluidCabinetEntity.clearControllerPos();
                                if (oldControllerPos != null && controllerLookup.containsKey(oldControllerPos)) {
                                    cabinetsToRemove.add(currentPos);
                                }
                            }
                            processed = true;
                        }
                    }
                    if (!processed) continue;
                    ++processedCount;
                }
            }
        }
        if (!cabinetsToAdd.isEmpty() && indexEntity != null) {
            indexEntity.addCabinets(cabinetsToAdd);
        }
        if (!cabinetsToRemove.isEmpty()) {
            block6: for (BlockPos cabinetPos : cabinetsToRemove) {
                for (FilingIndexBlockEntity controller : controllerLookup.values()) {
                    if (!controller.getLinkedCabinets().contains(cabinetPos)) continue;
                    controller.removeCabinet(cabinetPos);
                    continue block6;
                }
            }
        }
        MutableComponent message = data.operationMode() == LedgerData.OperationMode.ADD ? Component.translatable((String)"item.realfilingreborn.ledger.multi.linked", (Object[])new Object[]{processedCount}) : Component.translatable((String)"item.realfilingreborn.ledger.multi.unlinked", (Object[])new Object[]{processedCount});
        player.displayClientMessage((Component)message, true);
    }

    private boolean isInRange(BlockPos controllerPos, BlockPos cabinetPos, int range) {
        double rangeSq;
        double distSq = controllerPos.distSqr((Vec3i)cabinetPos);
        return distSq <= (rangeSq = (double)range * (double)range);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.realfilingreborn.ledger.subtitle").withStyle(ChatFormatting.LIGHT_PURPLE));
        LedgerData data = (LedgerData)stack.getOrDefault((DataComponentType)ModDataComponents.LEDGER_DATA.get(), (Object)LedgerData.DEFAULT);
        MutableComponent operationText = data.operationMode() == LedgerData.OperationMode.ADD ? Component.translatable((String)"item.realfilingreborn.ledger.tooltip.operation.add").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"item.realfilingreborn.ledger.tooltip.operation.remove").withStyle(ChatFormatting.RED);
        tooltip.add((Component)operationText);
        MutableComponent selectionText = data.selectionMode() == LedgerData.SelectionMode.SINGLE ? Component.translatable((String)"item.realfilingreborn.ledger.tooltip.selection.single").withStyle(ChatFormatting.AQUA) : Component.translatable((String)"item.realfilingreborn.ledger.tooltip.selection.multi").withStyle(ChatFormatting.LIGHT_PURPLE);
        tooltip.add((Component)selectionText);
        if (data.selectedController() != null) {
            MutableComponent controllerText = Component.translatable((String)"item.realfilingreborn.ledger.tooltip.controller.selected", (Object[])new Object[]{data.selectedController().getX(), data.selectedController().getY(), data.selectedController().getZ()}).withStyle(ChatFormatting.GREEN);
            tooltip.add((Component)controllerText);
        } else {
            MutableComponent noControllerText = Component.translatable((String)"item.realfilingreborn.ledger.tooltip.controller.none").withStyle(ChatFormatting.RED);
            tooltip.add((Component)noControllerText);
        }
        if (data.firstMultiPos() != null) {
            MutableComponent multiText = Component.translatable((String)"item.realfilingreborn.ledger.tooltip.multi.active", (Object[])new Object[]{data.firstMultiPos().getX(), data.firstMultiPos().getY(), data.firstMultiPos().getZ()}).withStyle(ChatFormatting.AQUA);
            tooltip.add((Component)multiText);
        }
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.realfilingreborn.ledger.tooltip.usage.selection").withColor(0xAAAAAA));
        tooltip.add((Component)Component.translatable((String)"item.realfilingreborn.ledger.tooltip.usage.operation").withColor(0xAAAAAA));
        tooltip.add((Component)Component.translatable((String)"item.realfilingreborn.ledger.tooltip.usage.controller").withColor(0xAAAAAA));
        tooltip.add((Component)Component.translatable((String)"item.realfilingreborn.ledger.tooltip.usage.cabinet").withColor(0xAAAAAA));
    }
}

