/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.item.custom;

import com.blocklogic.realfilingreborn.config.Config;
import com.blocklogic.realfilingreborn.screen.custom.FluidCanisterMenu;
import com.blocklogic.realfilingreborn.util.FluidHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FluidCanisterItem
extends Item {
    private static final Codec<CanisterContents> CANISTER_CONTENTS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("storedFluidId").forGetter(CanisterContents::storedFluidId), (App)Codec.INT.fieldOf("amount").forGetter(CanisterContents::amount)).apply((Applicative)instance, CanisterContents::new));
    public static final StreamCodec<ByteBuf, ResourceLocation> RESOURCE_LOCATION_STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ResourceLocation::parse, ResourceLocation::toString);
    private static final StreamCodec<ByteBuf, CanisterContents> CANISTER_CONTENTS_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(RESOURCE_LOCATION_STREAM_CODEC), CanisterContents::storedFluidId, (StreamCodec)ByteBufCodecs.INT, CanisterContents::amount, CanisterContents::new);
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"realfilingreborn");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CanisterContents>> CANISTER_CONTENTS = DATA_COMPONENTS.register("canister_contents", () -> DataComponentType.builder().persistent(CANISTER_CONTENTS_CODEC).networkSynchronized(CANISTER_CONTENTS_STREAM_CODEC).build());

    public FluidCanisterItem(Item.Properties properties) {
        super(properties);
        properties.component((DataComponentType)CANISTER_CONTENTS.value(), (Object)new CanisterContents(Optional.empty(), 0));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack canisterStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)canisterStack);
        }
        if (player.isShiftKeyDown()) {
            if (player instanceof ServerPlayer) {
                int finalSlotIndex;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int foundSlotIndex = -1;
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    if (player.getInventory().getItem(i) != canisterStack) continue;
                    foundSlotIndex = i;
                    break;
                }
                if ((finalSlotIndex = foundSlotIndex) != -1) {
                    MutableComponent title = Component.translatable((String)"gui.realfilingreborn.canister.title");
                    serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, playerEntity) -> new FluidCanisterMenu(containerId, inventory, finalSlotIndex), (Component)title), buf -> buf.writeInt(finalSlotIndex));
                    return InteractionResultHolder.success((Object)canisterStack);
                }
            }
            return InteractionResultHolder.success((Object)canisterStack);
        }
        ItemStack bucketStack = player.getItemInHand(InteractionHand.OFF_HAND);
        if (bucketStack.isEmpty() || !(bucketStack.getItem() instanceof BucketItem)) {
            return InteractionResultHolder.pass((Object)canisterStack);
        }
        BucketItem bucketItem = (BucketItem)bucketStack.getItem();
        Fluid fluid = bucketItem.content;
        if (!FluidHelper.isValidFluid(fluid)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.invalid_fluid"), true);
            return InteractionResultHolder.pass((Object)canisterStack);
        }
        if (!player.isShiftKeyDown() && canisterStack.getCount() > 1) {
            ItemStack singleCanister = canisterStack.copy();
            singleCanister.setCount(1);
            CanisterContents contents = (CanisterContents)singleCanister.get((DataComponentType)CANISTER_CONTENTS.value());
            if (contents == null) {
                contents = new CanisterContents(Optional.empty(), 0);
                singleCanister.set((DataComponentType)CANISTER_CONTENTS.value(), (Object)contents);
            }
            InteractionResultHolder<ItemStack> result = this.storeFluid(level, player, singleCanister, bucketStack, contents);
            ItemStack modifiedCanister = (ItemStack)result.getObject();
            canisterStack.shrink(1);
            if (!player.getInventory().add(modifiedCanister)) {
                player.drop(modifiedCanister, false);
            }
            return InteractionResultHolder.success((Object)canisterStack);
        }
        CanisterContents contents = (CanisterContents)canisterStack.get((DataComponentType)CANISTER_CONTENTS.value());
        if (contents == null) {
            contents = new CanisterContents(Optional.empty(), 0);
            canisterStack.set((DataComponentType)CANISTER_CONTENTS.value(), (Object)contents);
        }
        return this.storeFluid(level, player, canisterStack, bucketStack, contents);
    }

    private InteractionResultHolder<ItemStack> extractFluid(Level level, Player player, ItemStack canisterStack, CanisterContents contents) {
        if (contents == null || contents.storedFluidId().isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.canister_empty"), true);
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        if (contents.amount() <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.canister_empty"), true);
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        int emptyBucketCount = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != Items.BUCKET) continue;
            emptyBucketCount += stack.getCount();
        }
        if (emptyBucketCount <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.need_empty_bucket"), true);
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        ResourceLocation fluidId = contents.storedFluidId().get();
        ItemStack bucketToGive = FluidHelper.getBucketForFluid(fluidId);
        if (bucketToGive.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.no_bucket_for_fluid"), true);
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        int extractAmount = Math.min(contents.amount(), 1000);
        if (extractAmount < 1000) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.not_enough_fluid"), true);
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        boolean bucketRemoved = false;
        for (int i = 0; i < player.getInventory().getContainerSize() && !bucketRemoved; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != Items.BUCKET) continue;
            stack.shrink(1);
            bucketRemoved = true;
        }
        if (!bucketRemoved) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.need_empty_bucket"), true);
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        int newAmount = contents.amount() - 1000;
        CanisterContents newContents = new CanisterContents(contents.storedFluidId(), Math.max(0, newAmount));
        canisterStack.set((DataComponentType)CANISTER_CONTENTS.value(), (Object)newContents);
        if (player.getInventory().add(bucketToGive)) {
            return InteractionResultHolder.success((Object)canisterStack);
        }
        player.drop(bucketToGive, false);
        return InteractionResultHolder.success((Object)canisterStack);
    }

    private InteractionResultHolder<ItemStack> storeFluid(Level level, Player player, ItemStack canisterStack, ItemStack bucketStack, CanisterContents contents) {
        ResourceLocation effectiveFluidId;
        Item item = bucketStack.getItem();
        if (!(item instanceof BucketItem)) {
            return InteractionResultHolder.pass((Object)canisterStack);
        }
        BucketItem bucketItem = (BucketItem)item;
        Fluid fluid = bucketItem.content;
        if (!FluidHelper.isValidFluid(fluid)) {
            return InteractionResultHolder.pass((Object)canisterStack);
        }
        if (contents == null) {
            contents = new CanisterContents(Optional.empty(), 0);
            canisterStack.set((DataComponentType)CANISTER_CONTENTS.value(), (Object)contents);
        }
        ResourceLocation newFluidId = FluidHelper.getStillFluid(FluidHelper.getFluidId(fluid));
        if (contents == null) {
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        Optional<ResourceLocation> currentFluidIdOpt = contents.storedFluidId();
        if (currentFluidIdOpt.isEmpty()) {
            effectiveFluidId = newFluidId;
        } else {
            effectiveFluidId = currentFluidIdOpt.get();
            if (!FluidHelper.areFluidsCompatible(effectiveFluidId, newFluidId)) {
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.wrong_fluid_type", (Object[])new Object[]{Component.literal((String)FluidHelper.getFluidDisplayName(effectiveFluidId)).withStyle(ChatFormatting.YELLOW)}), true);
                return InteractionResultHolder.fail((Object)canisterStack);
            }
        }
        int maxToAdd = Config.getMaxCanisterStorage() - contents.amount();
        int toAdd = Math.min(1000, maxToAdd);
        if (toAdd <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.canister_full"), true);
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        CanisterContents newContents = new CanisterContents(Optional.of(effectiveFluidId), contents.amount() + toAdd);
        canisterStack.set((DataComponentType)CANISTER_CONTENTS.value(), (Object)newContents);
        bucketStack.shrink(1);
        ItemStack emptyBucket = new ItemStack((ItemLike)Items.BUCKET);
        if (!player.getInventory().add(emptyBucket)) {
            player.drop(emptyBucket, false);
        }
        return InteractionResultHolder.success((Object)canisterStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CanisterContents contents = (CanisterContents)stack.get((DataComponentType)CANISTER_CONTENTS.value());
        if (contents != null && contents.storedFluidId().isPresent()) {
            ResourceLocation fluidId = contents.storedFluidId().get();
            String fluidName = FluidHelper.getFluidDisplayName(fluidId);
            tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.stored_fluid", (Object[])new Object[]{Component.literal((String)fluidName).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
            if (contents.amount() > 0) {
                int buckets = contents.amount() / 1000;
                int millibuckets = contents.amount() % 1000;
                String amountText = buckets > 0 ? (millibuckets > 0 ? buckets + "." + millibuckets / 100 + "B" : buckets + "B") : millibuckets + "mB";
                tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.fluid_amount", (Object[])new Object[]{Component.literal((String)amountText).withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.empty_canister").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.unregistered_canister").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.canister_info").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.canister_gui_hint").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public record CanisterContents(Optional<ResourceLocation> storedFluidId, int amount) {
    }
}

