/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.item.custom;

import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.FluidCanisterItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EraserItem
extends Item {
    public EraserItem(Item.Properties properties) {
        super(properties.durability(64));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Record contents;
        ItemStack eraserStack = player.getItemInHand(hand);
        ItemStack itemInOffHand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (itemInOffHand.isEmpty() || !(itemInOffHand.getItem() instanceof FilingFolderItem) && !(itemInOffHand.getItem() instanceof NBTFilingFolderItem) && !(itemInOffHand.getItem() instanceof FluidCanisterItem)) {
            return InteractionResultHolder.pass((Object)eraserStack);
        }
        boolean hasContents = false;
        boolean isUnassigned = false;
        if (itemInOffHand.getItem() instanceof NBTFilingFolderItem) {
            contents = (NBTFilingFolderItem.NBTFolderContents)itemInOffHand.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
            if (contents != null && ((NBTFilingFolderItem.NBTFolderContents)contents).storedItems() != null && !((NBTFilingFolderItem.NBTFolderContents)contents).storedItems().isEmpty()) {
                hasContents = true;
            }
            if (contents == null || ((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().isEmpty()) {
                isUnassigned = true;
            }
        } else if (itemInOffHand.getItem() instanceof FilingFolderItem) {
            contents = (FilingFolderItem.FolderContents)itemInOffHand.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
            if (contents != null && ((FilingFolderItem.FolderContents)contents).count() > 0) {
                hasContents = true;
            }
            if (contents == null || ((FilingFolderItem.FolderContents)contents).storedItemId().isEmpty()) {
                isUnassigned = true;
            }
        } else if (itemInOffHand.getItem() instanceof FluidCanisterItem) {
            contents = (FluidCanisterItem.CanisterContents)itemInOffHand.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value());
            if (contents != null && ((FluidCanisterItem.CanisterContents)contents).amount() > 0) {
                hasContents = true;
            }
            if (contents == null || ((FluidCanisterItem.CanisterContents)contents).storedFluidId().isEmpty()) {
                isUnassigned = true;
            }
        }
        if (hasContents) {
            if (!level.isClientSide()) {
                if (itemInOffHand.getItem() instanceof FluidCanisterItem) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.canister_not_empty").withStyle(ChatFormatting.RED), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_not_empty").withStyle(ChatFormatting.RED), true);
                }
            }
            return InteractionResultHolder.consume((Object)eraserStack);
        }
        if (isUnassigned) {
            if (!level.isClientSide()) {
                if (itemInOffHand.getItem() instanceof FluidCanisterItem) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.canister_not_assigned").withStyle(ChatFormatting.RED), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_not_assigned").withStyle(ChatFormatting.RED), true);
                }
            }
            return InteractionResultHolder.consume((Object)eraserStack);
        }
        if (itemInOffHand.getItem() instanceof NBTFilingFolderItem) {
            contents = (NBTFilingFolderItem.NBTFolderContents)itemInOffHand.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
            if (contents != null && ((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().isPresent()) {
                itemInOffHand.remove((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
                itemInOffHand.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)new NBTFilingFolderItem.NBTFolderContents(Optional.empty(), new ArrayList<NBTFilingFolderItem.SerializedItemStack>()));
                if (!player.getAbilities().instabuild) {
                    this.damageEraser(eraserStack);
                }
                if (!level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_erased").withStyle(ChatFormatting.GREEN), true);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResultHolder.success((Object)eraserStack);
            }
        } else if (itemInOffHand.getItem() instanceof FilingFolderItem) {
            contents = (FilingFolderItem.FolderContents)itemInOffHand.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
            if (contents != null && ((FilingFolderItem.FolderContents)contents).storedItemId().isPresent()) {
                ItemStack freshFolder = new ItemStack((ItemLike)itemInOffHand.getItem());
                freshFolder.setCount(itemInOffHand.getCount());
                player.setItemInHand(InteractionHand.OFF_HAND, freshFolder);
                if (!player.getAbilities().instabuild) {
                    this.damageEraser(eraserStack);
                }
                if (!level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_erased").withStyle(ChatFormatting.GREEN), true);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResultHolder.success((Object)eraserStack);
            }
        } else if (itemInOffHand.getItem() instanceof FluidCanisterItem && (contents = (FluidCanisterItem.CanisterContents)itemInOffHand.get((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value())) != null && ((FluidCanisterItem.CanisterContents)contents).storedFluidId().isPresent()) {
            itemInOffHand.remove((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value());
            itemInOffHand.set((DataComponentType)FluidCanisterItem.CANISTER_CONTENTS.value(), (Object)new FluidCanisterItem.CanisterContents(Optional.empty(), 0));
            if (!player.getAbilities().instabuild) {
                this.damageEraser(eraserStack);
            }
            if (!level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.canister_erased").withStyle(ChatFormatting.GREEN), true);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            return InteractionResultHolder.success((Object)eraserStack);
        }
        return InteractionResultHolder.pass((Object)eraserStack);
    }

    private void damageEraser(ItemStack eraserStack) {
        int maxDamage;
        int currentDamage = eraserStack.getDamageValue();
        if (currentDamage < (maxDamage = eraserStack.getMaxDamage())) {
            eraserStack.setDamageValue(currentDamage + 1);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.eraser_info").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

