/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.item.custom;

import com.blocklogic.realfilingreborn.block.ModBlocks;
import com.blocklogic.realfilingreborn.block.custom.FilingCabinetBlock;
import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CabinetConversionItem
extends Item {
    public CabinetConversionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (state.getBlock() instanceof FilingCabinetBlock) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FilingCabinetBlockEntity) {
                FilingCabinetBlockEntity filingCabinetEntity = (FilingCabinetBlockEntity)blockEntity;
                boolean hasItems = false;
                for (int i = 0; i < filingCabinetEntity.inventory.getSlots(); ++i) {
                    if (filingCabinetEntity.inventory.getStackInSlot(i).isEmpty()) continue;
                    hasItems = true;
                    break;
                }
                if (hasItems) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.cabinet_must_be_empty").withStyle(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                BlockState newState = (BlockState)((Block)ModBlocks.FLUID_CABINET.get()).defaultBlockState().setValue((Property)FilingCabinetBlock.FACING, (Comparable)((Direction)state.getValue((Property)FilingCabinetBlock.FACING)));
                level.setBlock(pos, newState, 3);
                level.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.2f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.cabinet_converted").withStyle(ChatFormatting.GREEN), true);
                return InteractionResult.SUCCESS;
            }
        } else {
            if (state.is((Block)ModBlocks.FLUID_CABINET.get())) {
                if (!level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.already_fluid_cabinet").withStyle(ChatFormatting.YELLOW), true);
                }
                return InteractionResult.FAIL;
            }
            if (!level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.conversion_only_filing_cabinet").withStyle(ChatFormatting.RED), true);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.cabinet_conversion_kit_info").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.cabinet_conversion_usage").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

