/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.config;

import com.mojang.logging.LogUtils;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.slf4j.Logger;

public class Config {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
    public static ModConfigSpec COMMON_CONFIG;
    public static ModConfigSpec SPEC;
    public static final String CATEGORY_STORAGE_LIMITS = "storage_limits";
    public static final String CATEGORY_FILING_INDEX_RANGES = "filing_index_ranges";
    public static ModConfigSpec.IntValue MAX_FOLDER_STORAGE;
    public static ModConfigSpec.IntValue MAX_NBT_FOLDER_STORAGE;
    public static ModConfigSpec.IntValue MAX_CANISTER_STORAGE;
    public static ModConfigSpec.IntValue FILING_INDEX_BASE_RANGE;
    public static ModConfigSpec.IntValue IRON_RANGE_UPGRADE;
    public static ModConfigSpec.IntValue DIAMOND_RANGE_UPGRADE;
    public static ModConfigSpec.IntValue NETHERITE_RANGE_UPGRADE;

    public static void register(ModContainer container) {
        Config.registerCommonConfigs(container);
    }

    private static void registerCommonConfigs(ModContainer container) {
        Config.storageLimitsConfig();
        Config.filingIndexRangesConfig();
        SPEC = COMMON_CONFIG = COMMON_BUILDER.build();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG);
    }

    private static void storageLimitsConfig() {
        COMMON_BUILDER.comment("Storage Limits - Configure maximum storage capacities for folders and canisters").push(CATEGORY_STORAGE_LIMITS);
        MAX_FOLDER_STORAGE = COMMON_BUILDER.comment(new String[]{"Maximum items storable in filing folders", "Default: 2147483647 (unlimited)", "Minimum: 4096 (64 stacks)"}).defineInRange("max_folder_storage", Integer.MAX_VALUE, 4096, Integer.MAX_VALUE);
        MAX_NBT_FOLDER_STORAGE = COMMON_BUILDER.comment(new String[]{"Maximum items storable in NBT filing folders", "NBT folders store items with enchantments, custom names, etc.", "Lower limit due to complexity of NBT data storage", "WARNING: Large numbers of NBT items in a single folder could corrupt the save!", "Proceed with caution!", "", "Default: 128 items"}).defineInRange("max_nbt_folder_storage", 128, 16, 200);
        MAX_CANISTER_STORAGE = COMMON_BUILDER.comment(new String[]{"Maximum fluid storable in canisters (millibuckets)", "Default: 2147483647 (unlimited)", "Minimum: 64000 (64 buckets)"}).defineInRange("max_canister_storage", Integer.MAX_VALUE, 64000, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
    }

    private static void filingIndexRangesConfig() {
        COMMON_BUILDER.comment("Filing Index Ranges - Configure range limits for filing indexes and upgrades").push(CATEGORY_FILING_INDEX_RANGES);
        FILING_INDEX_BASE_RANGE = COMMON_BUILDER.comment(new String[]{"Base filing index range (blocks)", "This is the default range when no upgrades are installed", "Range covers radius around the filing index"}).defineInRange("base_range", 8, 4, 32);
        IRON_RANGE_UPGRADE = COMMON_BUILDER.comment(new String[]{"Iron upgrade range (blocks)", "Range when iron range upgrade is installed", "Replaces base range when upgrade is present"}).defineInRange("iron_range", 16, 8, 64);
        DIAMOND_RANGE_UPGRADE = COMMON_BUILDER.comment(new String[]{"Diamond upgrade range (blocks)", "Range when diamond range upgrade is installed", "Replaces base range when upgrade is present"}).defineInRange("diamond_range", 32, 16, 128);
        NETHERITE_RANGE_UPGRADE = COMMON_BUILDER.comment(new String[]{"Netherite upgrade range (blocks)", "Range when netherite range upgrade is installed", "Replaces base range when upgrade is present", "", "WARNING: Large ranges can impact server performance significantly!", "A range of 64 covers a 128x128 block area - use with caution on multiplayer servers", "Maximum range of 256 covers a 512x512 area and may cause severe lag!"}).defineInRange("netherite_range", 64, 32, 256);
        COMMON_BUILDER.pop();
    }

    public static int getMaxFolderStorage() {
        return (Integer)MAX_FOLDER_STORAGE.get();
    }

    public static int getMaxNBTFolderStorage() {
        return (Integer)MAX_NBT_FOLDER_STORAGE.get();
    }

    public static int getMaxCanisterStorage() {
        return (Integer)MAX_CANISTER_STORAGE.get();
    }

    public static int getFilingIndexBaseRange() {
        return (Integer)FILING_INDEX_BASE_RANGE.get();
    }

    public static int getIronRangeUpgrade() {
        return (Integer)IRON_RANGE_UPGRADE.get();
    }

    public static int getDiamondRangeUpgrade() {
        return (Integer)DIAMOND_RANGE_UPGRADE.get();
    }

    public static int getNetheriteRangeUpgrade() {
        return (Integer)NETHERITE_RANGE_UPGRADE.get();
    }

    public static void validateConfig() {
        if (Config.getMaxFolderStorage() < 4096) {
            LOGGER.warn("Folder storage limit ({}) is below recommended minimum of 4096 items", (Object)Config.getMaxFolderStorage());
        }
        if (Config.getMaxNBTFolderStorage() < 16) {
            LOGGER.warn("NBT folder storage limit ({}) is below minimum of 16 items", (Object)Config.getMaxNBTFolderStorage());
        }
        if (Config.getMaxCanisterStorage() < 64000) {
            LOGGER.warn("Canister storage limit ({}) is below recommended minimum of 64000mb", (Object)Config.getMaxCanisterStorage());
        }
        if (Config.getIronRangeUpgrade() <= Config.getFilingIndexBaseRange()) {
            LOGGER.warn("Iron range upgrade ({}) should be greater than base range ({})", (Object)Config.getIronRangeUpgrade(), (Object)Config.getFilingIndexBaseRange());
        }
        if (Config.getDiamondRangeUpgrade() <= Config.getIronRangeUpgrade()) {
            LOGGER.warn("Diamond range upgrade ({}) should be greater than iron range ({})", (Object)Config.getDiamondRangeUpgrade(), (Object)Config.getIronRangeUpgrade());
        }
        if (Config.getNetheriteRangeUpgrade() <= Config.getDiamondRangeUpgrade()) {
            LOGGER.warn("Netherite range upgrade ({}) should be greater than diamond range ({})", (Object)Config.getNetheriteRangeUpgrade(), (Object)Config.getDiamondRangeUpgrade());
        }
        if (Config.getNetheriteRangeUpgrade() > 128) {
            LOGGER.warn("Netherite range ({}) is very large and may impact server performance! Consider reducing for multiplayer servers.", (Object)Config.getNetheriteRangeUpgrade());
        }
        if (Config.getNetheriteRangeUpgrade() > 200) {
            LOGGER.error("Netherite range ({}) is extremely large! This WILL cause severe performance issues on multiplayer servers!", (Object)Config.getNetheriteRangeUpgrade());
        }
    }

    public static void loadConfig() {
        LOGGER.info("Real Filing Reborn configs reloaded");
        Config.validateConfig();
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        LOGGER.info("Real Filing Reborn configuration loaded");
        Config.logConfigValues();
        Config.validateConfig();
    }

    private static void logConfigValues() {
        LOGGER.info("Storage Limits Configuration:");
        LOGGER.info("  Max Folder Storage: {} items", (Object)(Config.getMaxFolderStorage() == Integer.MAX_VALUE ? "unlimited" : String.format("%,d", Config.getMaxFolderStorage())));
        LOGGER.info("  Max NBT Folder Storage: {} items", (Object)String.format("%,d", Config.getMaxNBTFolderStorage()));
        LOGGER.info("  Max Canister Storage: {}mb", (Object)(Config.getMaxCanisterStorage() == Integer.MAX_VALUE ? "unlimited" : String.format("%,d", Config.getMaxCanisterStorage())));
        LOGGER.info("Filing Index Ranges Configuration:");
        LOGGER.info("  Base Range: {} blocks ({}x{} area)", new Object[]{Config.getFilingIndexBaseRange(), Config.getFilingIndexBaseRange() * 2, Config.getFilingIndexBaseRange() * 2});
        LOGGER.info("  Iron Upgrade: {} blocks ({}x{} area)", new Object[]{Config.getIronRangeUpgrade(), Config.getIronRangeUpgrade() * 2, Config.getIronRangeUpgrade() * 2});
        LOGGER.info("  Diamond Upgrade: {} blocks ({}x{} area)", new Object[]{Config.getDiamondRangeUpgrade(), Config.getDiamondRangeUpgrade() * 2, Config.getDiamondRangeUpgrade() * 2});
        LOGGER.info("  Netherite Upgrade: {} blocks ({}x{} area)", new Object[]{Config.getNetheriteRangeUpgrade(), Config.getNetheriteRangeUpgrade() * 2, Config.getNetheriteRangeUpgrade() * 2});
        int netheriteArea = Config.getNetheriteRangeUpgrade() * 2 * (Config.getNetheriteRangeUpgrade() * 2);
        if (netheriteArea > 65536) {
            LOGGER.warn("Netherite upgrade covers {} blocks - this is a very large area!", (Object)String.format("%,d", netheriteArea));
        }
    }
}

