/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;

public record LedgerData(OperationMode operationMode, SelectionMode selectionMode, @Nullable BlockPos selectedController, @Nullable BlockPos firstMultiPos) {
    public static final Codec<LedgerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OperationMode.CODEC.optionalFieldOf("operationMode", (Object)OperationMode.ADD).forGetter(LedgerData::operationMode), (App)SelectionMode.CODEC.optionalFieldOf("selectionMode", (Object)SelectionMode.SINGLE).forGetter(LedgerData::selectionMode), (App)BlockPos.CODEC.optionalFieldOf("selectedController").forGetter(data -> Optional.ofNullable(data.selectedController())), (App)BlockPos.CODEC.optionalFieldOf("firstMultiPos").forGetter(data -> Optional.ofNullable(data.firstMultiPos()))).apply((Applicative)instance, (opMode, selMode, controller, multiPos) -> new LedgerData((OperationMode)((Object)((Object)opMode)), (SelectionMode)((Object)((Object)selMode)), controller.orElse(null), multiPos.orElse(null))));
    public static final LedgerData DEFAULT = new LedgerData(OperationMode.ADD, SelectionMode.SINGLE, null, null);

    public LedgerData withOperationMode(OperationMode operationMode) {
        return new LedgerData(operationMode, this.selectionMode, this.selectedController, this.firstMultiPos);
    }

    public LedgerData withSelectionMode(SelectionMode selectionMode) {
        return new LedgerData(this.operationMode, selectionMode, this.selectedController, this.firstMultiPos);
    }

    public LedgerData withSelectedController(@Nullable BlockPos selectedController) {
        return new LedgerData(this.operationMode, this.selectionMode, selectedController, this.firstMultiPos);
    }

    public LedgerData withFirstMultiPos(@Nullable BlockPos firstMultiPos) {
        return new LedgerData(this.operationMode, this.selectionMode, this.selectedController, firstMultiPos);
    }

    public static enum OperationMode {
        ADD,
        REMOVE;

        public static final Codec<OperationMode> CODEC;

        static {
            CODEC = Codec.stringResolver(Enum::name, name -> {
                try {
                    return OperationMode.valueOf(name.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return ADD;
                }
            });
        }
    }

    public static enum SelectionMode {
        SINGLE,
        MULTI;

        public static final Codec<SelectionMode> CODEC;

        static {
            CODEC = Codec.stringResolver(Enum::name, name -> {
                try {
                    return SelectionMode.valueOf(name.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return SINGLE;
                }
            });
        }
    }
}

