/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.compat.jade;

import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.config.Config;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum FilingCabinetProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (!data.contains("folders")) {
            return;
        }
        ListTag folders = data.getList("folders", 10);
        if (folders.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.jade.empty_cabinet").withStyle(ChatFormatting.GRAY));
            return;
        }
        for (int i = 0; i < folders.size(); ++i) {
            CompoundTag folderTag = folders.getCompound(i);
            if (!folderTag.contains("item_id")) continue;
            int slot = folderTag.getInt("slot");
            String itemName = folderTag.getString("item_name");
            if (folderTag.getBoolean("is_nbt")) {
                int uniqueCount = folderTag.getInt("unique_count");
                tooltip.add((Component)Component.literal((String)("Folder " + (slot + 1) + " (NBT): " + itemName + " (" + uniqueCount + " items)")).withStyle(ChatFormatting.AQUA));
                continue;
            }
            int count = folderTag.getInt("count");
            String formattedCount = NumberFormat.getNumberInstance(Locale.US).format(count);
            double fillPercentage = (double)count / (double)Config.getMaxFolderStorage() * 100.0;
            String percentText = String.format("%.2f%%", fillPercentage);
            tooltip.add((Component)Component.literal((String)("Folder " + (slot + 1) + ": " + itemName + " (" + formattedCount + ", " + percentText + ")")).withStyle(ChatFormatting.WHITE));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof FilingCabinetBlockEntity)) {
            return;
        }
        FilingCabinetBlockEntity cabinetEntity = (FilingCabinetBlockEntity)blockEntity;
        ListTag foldersList = new ListTag();
        for (int i = 0; i < 5; ++i) {
            ItemStack stackInSlot = cabinetEntity.inventory.getStackInSlot(i);
            CompoundTag folderTag = new CompoundTag();
            folderTag.putInt("slot", i);
            if (!stackInSlot.isEmpty()) {
                Record contents;
                if (stackInSlot.getItem() instanceof FilingFolderItem && !(stackInSlot.getItem() instanceof NBTFilingFolderItem)) {
                    contents = (FilingFolderItem.FolderContents)stackInSlot.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                    if (contents != null && ((FilingFolderItem.FolderContents)contents).storedItemId().isPresent()) {
                        itemId = ((FilingFolderItem.FolderContents)contents).storedItemId().get();
                        folderTag.putString("item_id", itemId.toString());
                        folderTag.putString("item_name", ((Item)BuiltInRegistries.ITEM.get(itemId)).getDescription().getString());
                        folderTag.putInt("count", ((FilingFolderItem.FolderContents)contents).count());
                        folderTag.putBoolean("is_nbt", false);
                    }
                } else if (stackInSlot.getItem() instanceof NBTFilingFolderItem && (contents = (NBTFilingFolderItem.NBTFolderContents)stackInSlot.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value())) != null && ((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().isPresent()) {
                    itemId = ((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().get();
                    folderTag.putString("item_id", itemId.toString());
                    folderTag.putString("item_name", ((Item)BuiltInRegistries.ITEM.get(itemId)).getDescription().getString());
                    folderTag.putInt("unique_count", ((NBTFilingFolderItem.NBTFolderContents)contents).storedItems().size());
                    folderTag.putBoolean("is_nbt", true);
                }
            }
            foldersList.add((Object)folderTag);
        }
        data.put("folders", (Tag)foldersList);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"realfilingreborn", (String)"filing_cabinet_info");
    }
}

